/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioEstoqueBaixoBean;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioProdutosEstoqueBaixoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private ComboBox<CategoriaProduto> cbbCategoria;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
    }

    private void geraRelatorio() {
        CategoriaProduto categoriaProduto = (CategoriaProduto)this.cbbCategoria.getSelectionModel().getSelectedItem();
        List produtos = this.produtoService.relatorioEstoqueBaixo(categoriaProduto);
        if (produtos == null || produtos.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum registro encontrado para o filtro informado.");
            return;
        }
        ArrayList lista = new ArrayList();
        produtos.forEach(produto -> lista.add(new RelatorioEstoqueBaixoBean(produto)));
        Configuracao conf = this.configuracaoService.load();
        try {
            Integer quantidadeProdutos = lista.size();
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            params.put("QTDE_PRODUTOS", quantidadeProdutos);
            params.put("CATEGORIA", categoriaProduto == null ? "CATEGORIA PRODUTO: TODAS" : "CATEGORIA PRODUTO: " + categoriaProduto.getNome().toUpperCase());
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(lista);
            new PrintReport().showReport("/jasper/estoque/produto/lista-produtos-estoque-baixo.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioProdutosEstoqueBaixoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void carregaIcones() {
        this.btnGeraRelatorio.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
        this.cbbCategoria.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.combo()));
    }
}

