/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioVendaProdutoFaturamentoBean;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioVendaProdutoPorDia;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioVendaProdutoPorDiaBean;
import br.com.maximasolutions.estoque.relatorio.controller.RelatorioVendaProdutoController;
import br.com.maximasolutions.estoque.report.VendaProdutoReport;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioVendaPorDiaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private VendedorService vendedorService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private ComboBox<Vendedor> cbbVendedor;
    private BigDecimal total;
    private BigDecimal totalLiquido;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.loadCombos();
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        List lista = this.vendaProdutoService.relatorio((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), (Vendedor)this.cbbVendedor.getSelectionModel().getSelectedItem());
        ArrayList<RelatorioVendaProdutoPorDia> relatorio = new ArrayList<RelatorioVendaProdutoPorDia>();
        RelatorioVendaProdutoPorDia relatorioDia = new RelatorioVendaProdutoPorDia();
        List formasDeRecebimentos = this.vendaProdutoService.faturamentos((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), (Vendedor)this.cbbVendedor.getSelectionModel().getSelectedItem());
        ArrayList faturamentos = new ArrayList();
        formasDeRecebimentos.forEach(obj -> {
            String descricao = (String)obj[0];
            BigDecimal valor = (BigDecimal)obj[1];
            faturamentos.add(new RelatorioVendaProdutoFaturamentoBean(descricao, valor));
        });
        relatorioDia.setDias(lista);
        relatorioDia.setFaturamentos(faturamentos);
        relatorio.add(relatorioDia);
        this.calculaTotal(lista);
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            String filtro = "PER\u00cdODO DE: " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " \u00e0 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            URL web = VendaProdutoReport.class.getResource("/jasper/estoque/vendaProduto/");
            params.put("subrel", web.toString());
            params.put("FILTRO", filtro);
            params.put("CNPJ", conf.getCnpjEmpresa());
            params.put("TELEFONE", conf.getTelefoneEmpresa());
            params.put("ENDERECO", conf.getEmpresaNFe().getEnderecoCompleto().toUpperCase());
            params.put("TOTAL_BRUTO", this.total);
            params.put("TOTAL_LIQUIDO", this.totalLiquido);
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(relatorio);
            String jasper = "vendas_por_dia.jasper";
            new PrintReport().showReport("/jasper/estoque/vendaProduto/" + jasper, (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioVendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<RelatorioVendaProdutoPorDiaBean> listaDeVendasPorDia) {
        this.total = BigDecimal.ZERO;
        this.totalLiquido = BigDecimal.ZERO;
        for (RelatorioVendaProdutoPorDiaBean bean : listaDeVendasPorDia) {
            this.total = this.total.add(bean.getValorBruto());
            if (bean.getValorLiquido() == null) continue;
            this.totalLiquido = this.totalLiquido.add(bean.getValorLiquido());
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
        ArrayList vendedores = new ArrayList();
        vendedores.add(null);
        vendedores.addAll(this.vendedorService.list());
        this.cbbVendedor.setItems(FXCollections.observableList(vendedores));
    }
}

