/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.bean.VendaProdutoItemBean;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioVendaProdutoCategoriaClienteController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ClienteService clienteService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnClientePesquisa;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfClientePesquisa;
    @FXML
    private TextField tfClienteNome;
    private BigDecimal quantidade;
    private BigDecimal total;
    private BigDecimal custoMedio;
    private BigDecimal precoMedio;
    private BigDecimal custoTotal;
    private Integer produtos;
    private Cliente cliente;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        List itens = this.vendaProdutoService.relatorioProdutosAgrupadosCliente((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), Boolean.valueOf(true), this.cliente);
        if (itens == null || itens.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        this.calculaTotal(itens);
        String jasper = "vendas-produtos-categorias-cliente.jasper";
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            String filtro = "PER\u00cdODO DE: " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " \u00e0 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            if (this.cliente != null) {
                filtro = filtro + " | CLIENTE: " + this.cliente.getNome().toUpperCase();
            }
            params.put("FILTRO", filtro);
            params.put("QUANTIDADE", this.quantidade);
            params.put("PRODUTOS", this.produtos);
            params.put("TOTAL", this.total);
            params.put("TOTAL_CUSTO", this.custoTotal);
            params.put("LIQUIDO", this.total.subtract(this.custoTotal));
            params.put("CUSTO_MEDIO", this.custoMedio);
            params.put("PRECO_MEDIO", this.precoMedio);
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)itens);
            new PrintReport().showReport("/jasper/estoque/vendaProduto/" + jasper, (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioVendaProdutoCategoriaClienteController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<VendaProdutoItemBean> itens) {
        this.total = BigDecimal.ZERO;
        this.quantidade = BigDecimal.ZERO;
        this.custoTotal = BigDecimal.ZERO;
        this.custoMedio = BigDecimal.ZERO;
        this.precoMedio = BigDecimal.ZERO;
        this.produtos = 0;
        ArrayList<VendaProdutoItemBean> produtosAdicionados = new ArrayList<VendaProdutoItemBean>();
        for (VendaProdutoItemBean bean : itens) {
            this.quantidade = this.quantidade.add(bean.getQuantidade());
            this.total = this.total.add(bean.getTotal());
            this.custoTotal = this.custoTotal.add(bean.getCustoTotal());
            this.custoMedio = this.custoMedio.add(bean.getCustoUnitario());
            this.precoMedio = this.precoMedio.add(bean.getValorMedio());
            boolean existe = false;
            for (VendaProdutoItemBean b : produtosAdicionados) {
                if (!bean.getProdutoId().equals(b.getProdutoId())) continue;
                existe = true;
                break;
            }
            if (existe) continue;
            produtosAdicionados.add(bean);
        }
        this.produtos = produtosAdicionados.size();
        this.custoMedio = this.custoMedio.divide(new BigDecimal(itens.size()), 2, RoundingMode.HALF_EVEN);
        this.precoMedio = this.precoMedio.divide(new BigDecimal(itens.size()), 2, RoundingMode.HALF_EVEN);
        for (VendaProdutoItemBean bean : produtosAdicionados) {
            BigDecimal percentual = bean.getTotal().multiply(new BigDecimal(100)).divide(this.total, 2, RoundingMode.HALF_EVEN);
            bean.setPercentual(percentual);
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.tfClientePesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.btnClientePesquisa.setOnAction(event -> this.pesquisaClienteForm());
    }

    private void loadCombos() {
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClientePesquisa.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                this.cliente = clientePesquisa;
            } else {
                this.cliente = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de cliente n\u00e3o encontrado.");
                this.tfClientePesquisa.requestFocus();
                this.tfClientePesquisa.selectAll();
            }
            this.loadDadosCliente();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaClienteForm();
            return;
        }
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnClientePesquisa.getScene(), this.tfClientePesquisa.getText());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClientePesquisa.setText(this.cliente.getId().toString());
            this.tfClienteNome.setText(this.cliente.getNome().toUpperCase());
        } else {
            this.tfClienteNome.setText("");
            this.tfClientePesquisa.setText("");
            this.tfClientePesquisa.requestFocus();
        }
    }
}

