/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.bean.VendaProdutoItemBean;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioVendaProdutoCategoriaVendedorController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private VendedorService vendedorService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private ComboBox<Vendedor> cbbVendedor;
    private BigDecimal quantidade;
    private BigDecimal total;
    private BigDecimal custoMedio;
    private BigDecimal precoMedio;
    private BigDecimal custoTotal;
    private Integer produtos;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        Vendedor vendedor = (Vendedor)this.cbbVendedor.getSelectionModel().getSelectedItem();
        if (vendedor == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um vendedor para emitir o relat\u00f3rio.");
            return;
        }
        List itens = this.vendaProdutoService.relatorioProdutosAgrupados((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), Boolean.valueOf(true), vendedor);
        if (itens == null || itens.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        this.calculaTotal(itens);
        String jasper = "vendas-produtos-categorias-vendedor.jasper";
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            String filtro = "PER\u00cdODO DE: " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " \u00e0 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            filtro = filtro + " | FUNCION\u00c1RIO: " + vendedor.getNome().toUpperCase();
            params.put("FILTRO", filtro);
            params.put("QUANTIDADE", this.quantidade);
            params.put("PRODUTOS", this.produtos);
            params.put("TOTAL", this.total);
            params.put("TOTAL_CUSTO", this.custoTotal);
            params.put("LIQUIDO", this.total.subtract(this.custoTotal));
            params.put("CUSTO_MEDIO", this.custoMedio);
            params.put("PRECO_MEDIO", this.precoMedio);
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)itens);
            new PrintReport().showReport("/jasper/estoque/vendaProduto/" + jasper, (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioVendaProdutoCategoriaVendedorController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<VendaProdutoItemBean> itens) {
        this.total = BigDecimal.ZERO;
        this.quantidade = BigDecimal.ZERO;
        this.custoTotal = BigDecimal.ZERO;
        this.custoMedio = BigDecimal.ZERO;
        this.precoMedio = BigDecimal.ZERO;
        this.produtos = 0;
        ArrayList<VendaProdutoItemBean> produtosAdicionados = new ArrayList<VendaProdutoItemBean>();
        for (VendaProdutoItemBean bean : itens) {
            this.quantidade = this.quantidade.add(bean.getQuantidade());
            this.total = this.total.add(bean.getTotal());
            this.custoTotal = this.custoTotal.add(bean.getCustoTotal());
            this.custoMedio = this.custoMedio.add(bean.getCustoUnitario());
            this.precoMedio = this.precoMedio.add(bean.getValorMedio());
            boolean existe = false;
            for (VendaProdutoItemBean b : produtosAdicionados) {
                if (!bean.getProdutoId().equals(b.getProdutoId())) continue;
                existe = true;
                break;
            }
            if (existe) continue;
            produtosAdicionados.add(bean);
        }
        this.produtos = produtosAdicionados.size();
        this.custoMedio = this.custoMedio.divide(new BigDecimal(itens.size()), 2, RoundingMode.HALF_EVEN);
        this.precoMedio = this.precoMedio.divide(new BigDecimal(itens.size()), 2, RoundingMode.HALF_EVEN);
        for (VendaProdutoItemBean bean : produtosAdicionados) {
            BigDecimal percentual = bean.getTotal().multiply(new BigDecimal(100)).divide(this.total, 2, RoundingMode.HALF_EVEN);
            bean.setPercentual(percentual);
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
        ArrayList vendedores = new ArrayList();
        vendedores.add(null);
        vendedores.addAll(this.vendedorService.list());
        this.cbbVendedor.setItems(FXCollections.observableList(vendedores));
    }
}

