/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.report;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.modelo.BaixaProduto;
import br.com.maximasolutions.estoque.modelo.BaixaProdutoItem;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class BaixaProdutoReport {
    private final Configuracao conf;
    private final String jasper;
    private Map<String, Object> params;
    private JRDataSource jrds;

    public BaixaProdutoReport(Configuracao conf1) {
        this.conf = conf1;
        this.jasper = "/jasper/estoque/baixaProduto/baixa_produto_view.jasper";
    }

    public void visualiza(BaixaProduto orcamento, List<BaixaProdutoItem> itens) throws MaximaException {
        try {
            this.geraRelatorio(itens);
            new PrintReport().showReport(this.jasper, this.jrds, this.params);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(BaixaProdutoReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de visualiza\u00e7\u00e3o da venda.\n" + ex.getMessage());
        }
    }

    public void exportaPdf(BaixaProduto orcamento, List<BaixaProdutoItem> itens, String arquivoDestino) throws MaximaException {
        try {
            this.geraRelatorio(itens);
            new PrintReport().exportaReport(this.jasper, this.jrds, this.params, arquivoDestino);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(BaixaProdutoReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de visualiza\u00e7\u00e3o da venda.\n" + ex.getMessage());
        }
    }

    private void geraRelatorio(List<BaixaProdutoItem> itens) {
        this.jrds = new JRBeanCollectionDataSource(itens);
        this.params = new HashMap();
        this.params.put("EMPRESA", this.conf.getNomeEmpresa());
        this.params.put("CNPJ", this.conf.getCnpjEmpresa());
        this.params.put("ENDERECO", this.conf.getEmpresaNFe().getEnderecoCompleto());
        this.params.put("TELEFONE", this.conf.getTelefoneEmpresa());
        this.params.put("CIDADE", this.conf.getEmpresaNFe().getMunicipio().getNome() + "/" + this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
        this.params.put("Logo", "logo.png");
        URL web = BaixaProdutoReport.class.getResource("/jasper/estoque/baixaProduto/");
        this.params.put("subrel", web.toString());
    }
}

