/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrimaItem;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.repository.EntradaMateriaPrimaItemRepositoryCustom;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EntradaMateriaPrimaItemRepository
extends JpaRepository<EntradaMateriaPrimaItem, Long>,
EntradaMateriaPrimaItemRepositoryCustom {
    @Query(value="SELECT o FROM EntradaMateriaPrimaItem o WHERE o.ativo = true AND o.excluido = false AND o.entradaMateriaPrima.id = :entradaMateriaPrimaId ORDER BY o.id DESC")
    public List<EntradaMateriaPrimaItem> lista(@Param(value="entradaMateriaPrimaId") long var1);

    @Query(value="SELECT o.unidade FROM EntradaMateriaPrimaItem o WHERE o.ativo = true AND o.excluido = false AND (o.entradaMateriaPrima.dataEmissao between :dataInicio and :dataFim) AND o.entradaMateriaPrima.excluida = false AND o.entradaMateriaPrima.xml is not null GROUP BY o.unidade")
    public List<String> listaSpedTipoUnidade(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT o.materiaPrima FROM EntradaMateriaPrimaItem o WHERE o.ativo = true AND o.excluido = false AND (o.entradaMateriaPrima.dataEmissao between :dataInicio and :dataFim) AND o.entradaMateriaPrima.excluida = false AND o.entradaMateriaPrima.xml is not null GROUP BY o.materiaPrima.id")
    public List<MateriaPrima> listaSpedMateriaPrima(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT o.materiaPrima.unidade.sigla FROM EntradaMateriaPrimaItem o WHERE o.ativo = true AND o.excluido = false AND (o.entradaMateriaPrima.dataEmissao between :dataInicio and :dataFim) AND o.entradaMateriaPrima.excluida = false AND o.entradaMateriaPrima.xml is not null GROUP BY o.materiaPrima.unidade.sigla")
    public List<String> listaSpedMateriaPrimaUnidades(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT o.cst, o.cfopFiscal, o.aliquotaIcms, sum(o.totalCusto), sum(o.baseCalculoIcms), sum(o.valorIcms), sum(o.baseCalculoIcmsST), sum(o.valorIcmsST), sum(o.quantidade * o.precoCusto - o.baseCalculoIcms), sum(o.valorIpi), o.csosn FROM EntradaMateriaPrimaItem o WHERE o.ativo = true AND o.excluido = false AND o.entradaMateriaPrima.id = :entradaMateriaPrimaId GROUP BY o.cst, o.cfopEntrada, o.aliquotaIcms")
    public List<Object[]> listaSpedRegistro190(@Param(value="entradaMateriaPrimaId") long var1);
}

