/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.bean.EntradaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.repository.EntradaMateriaPrimaItemRepositoryCustom;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public class EntradaMateriaPrimaItemRepositoryCustomImpl
implements EntradaMateriaPrimaItemRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public List<Object[]> relatorio(LocalDate inicio, LocalDate fim, Fornecedor fornecedor, Boolean agruparProdutos, EntradaProdutoItemOrderBy orderBy) {
        String order;
        String hql;
        if (agruparProdutos.booleanValue()) {
            hql = "SELECT o.materiaPrima.codigo, o.descricao, o.unidade, sum(o.quantidade), avg(o.precoCusto), sum(o.totalCusto), sum(o.desconto), o.materiaPrima.id, o.entradaMateriaPrima.id, o.unidadeEntrada FROM EntradaMateriaPrimaItem o WHERE (o.entradaMateriaPrima.dataEmissao between :inicio and :fim) AND o.entradaMateriaPrima.excluida = false";
            order = " GROUP BY o.materiaPrima.id ORDER BY o.materiaPrima.nome ASC";
        } else {
            hql = "SELECT o.materiaPrima.codigo, o.descricao, o.unidade, o.quantidade, o.precoCusto, o.totalCusto, o.desconto, o.materiaPrima.id, o.entradaMateriaPrima.id, o.unidadeEntrada, o.entradaMateriaPrima.dataEmissao FROM EntradaMateriaPrimaItem o WHERE (o.entradaMateriaPrima.dataEmissao between :inicio and :fim) AND o.entradaMateriaPrima.excluida = false AND o.ativo = true";
            order = orderBy.equals((Object)EntradaProdutoItemOrderBy.PRODUTO) ? " ORDER BY o.materiaPrima.nome ASC" : " ORDER BY o.entradaMateriaPrima.dataEmissao ASC";
        }
        String where = "";
        if (fornecedor != null) {
            where = where + " AND o.entradaMateriaPrima.fornecedor.id = " + fornecedor.getId() + " ";
        }
        return this.entityManager.createQuery(hql + where + order).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }
}

