/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.bean.EntradaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.repository.EntradaProdutoItemRepositoryCustom;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public class EntradaProdutoItemRepositoryCustomImpl
implements EntradaProdutoItemRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public List<Object[]> relatorio(LocalDate inicio, LocalDate fim, Fornecedor fornecedor, CategoriaProduto categoriaProduto, Boolean agruparProdutos, EntradaProdutoItemOrderBy orderBy) {
        String order;
        String hql;
        if (agruparProdutos.booleanValue()) {
            hql = "SELECT o.produto.codigo, o.produto.categoriaProduto.nome, o.descricao, o.unidade, sum(o.quantidade), avg(o.precoCusto), sum(o.totalCusto), sum(o.desconto), o.produto.id, o.entradaProduto.id, o.unidade FROM EntradaProdutoItem o WHERE (o.entradaProduto.dataEmissao between :inicio and :fim) AND o.entradaProduto.excluida = false";
            order = " GROUP BY o.produto.id ORDER BY o.produto.nome ASC";
        } else {
            hql = "SELECT o.produto.codigo, o.produto.categoriaProduto.nome, o.descricao, o.unidade, o.quantidade, o.precoUnitario, o.precoTotal, o.desconto, o.precoCusto, o.servicoCusto, o.produto.id, o.vendaProduto.id, o.vendaProduto.dataEmissao FROM VendaProdutoItem o WHERE (o.vendaProduto.dataEmissao between :inicio and :fim) AND o.vendaProduto.excluida = false AND o.ativo = true";
            order = orderBy.equals((Object)EntradaProdutoItemOrderBy.PRODUTO) ? " ORDER BY o.produto.nome ASC" : " ORDER BY o.vendaProduto.dataEmissao ASC";
        }
        String where = "";
        if (fornecedor != null) {
            where = where + " AND o.entradaProduto.fornecedor.id = " + fornecedor.getId() + " ";
        }
        if (categoriaProduto != null) {
            where = where + " AND o.produto.categoriaProduto.id = " + categoriaProduto.getId() + " ";
        }
        return this.entityManager.createQuery(hql + where + order).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }
}

