/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.PedidoItem;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PedidoItemRepository
extends JpaRepository<PedidoItem, Long> {
    @Query(value="SELECT o FROM PedidoItem o WHERE o.pedido.id = :pedidoId AND o.excluido = FALSE AND o.produto.id IN (SELECT p.produto.id FROM PromocaoProduto p WHERE p.promocao.id = :promocaoId)")
    public List<PedidoItem> itensPromocao(@Param(value="pedidoId") Long var1, @Param(value="promocaoId") Long var2);

    @Query(value="SELECT sum(o.quantidade) FROM PedidoItem o WHERE o.pedido.id = :pedidoId AND o.excluido = FALSE AND o.produto.id IN (SELECT p.produto.id FROM PromocaoProduto p WHERE p.promocao.id = :promocaoId)")
    public BigDecimal quantidadeItensPromocao(@Param(value="pedidoId") Long var1, @Param(value="promocaoId") Long var2);

    @Query(value="SELECT o FROM PedidoItem o WHERE o.pedido.id = :pedidoId AND o.excluido = FALSE ORDER BY o.dataMovimento")
    public List<PedidoItem> itens(@Param(value="pedidoId") Long var1);

    @Query(value="SELECT o FROM PedidoItem o WHERE o.pedido.id = :pedidoId ORDER BY o.dataMovimento")
    public List<PedidoItem> itensAll(@Param(value="pedidoId") Long var1);

    @Query(value="SELECT COUNT(o.id) FROM PedidoItem o WHERE o.pedido.id = :pedidoId AND o.excluido = false")
    public Long count(@Param(value="pedidoId") Long var1);

    @Query(value="SELECT o FROM PedidoItem o WHERE o.pedido.id = :pedidoId AND o.excluido = false AND o.numItem = :numeroItem")
    public PedidoItem get(@Param(value="numeroItem") Integer var1, @Param(value="pedidoId") Long var2);

    @Modifying
    @Query(value="UPDATE PedidoItem o SET o.excluido = FALSE WHERE o.pedido.id = :pedidoId")
    public void deletePedido(@Param(value="pedidoId") Long var1);

    @Query(value="SELECT o FROM PedidoItem o WHERE o.pedido.movimentoCaixa.id = :movimentoCaixaId AND o.excluido = TRUE AND o.pedido.excluido = FALSE ORDER BY o.dataMovimento")
    public List<PedidoItem> listaCanceladosPorCaixa(@Param(value="movimentoCaixaId") Long var1);
}

