/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.repository.ProdutoRepositoryCustom;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ProdutoRepository
extends JpaRepository<Produto, Long>,
ProdutoRepositoryCustom {
    @Query(value="select o from Produto o order by o.id")
    public List<Produto> listaTodos();

    @Query(value="select o from Produto o order by o.id")
    public List<Produto> lista(Pageable var1);

    @Query(value="select o from Produto o where o.ativo = true order by o.nome")
    public List<Produto> listaAtivos();

    @Query(value="select o from Produto o where o.ativo = true order by o.ordem, o.id")
    public List<Produto> listaOrdenado();

    @Query(value="SELECT o FROM Produto o WHERE o.ativo = true AND o.codigo like :codigo")
    public Produto getByCodigoBarras(@Param(value="codigo") String var1);

    @Query(value="SELECT o FROM Produto o WHERE o.ativo = true AND o.codigo like :codigo")
    public List<Produto> listaPorCodigoDeBarras(@Param(value="codigo") String var1);

    @Query(value="SELECT o FROM Produto o WHERE o.ativo = true AND o.codigoEntrada like :codigo")
    public List<Produto> getByCodigoEntrada(@Param(value="codigo") String var1);

    @Query(value="SELECT o FROM Produto o WHERE o.ativo = true AND o.referencia like :codigo ORDER BY o.nome")
    public List<Produto> getByCodigoInterno(@Param(value="codigo") String var1);

    @Query(value="SELECT o FROM Produto o WHERE o.ativo = true AND (o.nome like :valor or o.codigo like :codigo or o.referencia like :codigo) ORDER BY o.nome")
    public List<Produto> pesquisa(@Param(value="valor") String var1, @Param(value="codigo") String var2);

    @Query(value="SELECT o FROM Produto o WHERE o.ativo = true AND o.balanca = true ORDER BY o.nome")
    public List<Produto> listaBalanca();

    @Query(value="SELECT o FROM Produto o WHERE o.sincronizado = false or o.sincronizado is null ORDER BY o.id")
    public List<Produto> sincronizar();

    @Query(value="SELECT o FROM Produto o WHERE o.ativo = true ORDER BY o.nome")
    public List<Produto> listaSped();

    @Query(value="SELECT o FROM Produto o ORDER BY o.id")
    public List<Produto> manutencao(Pageable var1);

    @Query(value="SELECT o FROM Produto o WHERE o.produtoPaiTamanho.id =:produtoPaiId and ativo = true ORDER BY o.id")
    public List<Produto> listaProdutosTamanhos(@Param(value="produtoPaiId") Long var1);

    @Query(value="SELECT o FROM Produto o WHERE o.vendasExternas = TRUE ORDER BY o.id")
    public List<Produto> listaAplicativo();

    @Query(value="SELECT o FROM Produto o WHERE o.uuid like :uuid")
    public Produto get(@Param(value="uuid") String var1);

    @Query(value="SELECT o FROM Produto o WHERE o.id = :id")
    public Produto get(@Param(value="id") long var1);
}

