/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface VendaProdutoFaturamentoRepository
extends JpaRepository<VendaProdutoFaturamento, Long> {
    @Query(value="SELECT o FROM VendaProdutoFaturamento o WHERE o.vendaProduto.id = :vendaProdutoId ORDER BY o.dataEntrada")
    public List<VendaProdutoFaturamento> lista(@Param(value="vendaProdutoId") Long var1);

    @Query(value="SELECT o.condicaoRecebimento.nome, sum(o.valor) FROM VendaProdutoFaturamento o WHERE o.vendaProduto.excluida = false AND o.vendaProduto.faturado = true AND o.vendaProduto.movimentoCaixa.id = :movimentoCaixaId GROUP BY o.condicaoRecebimento.id")
    public List<Object[]> listaPorCaixa(@Param(value="movimentoCaixaId") Long var1);

    @Query(value="SELECT o.condicaoRecebimento.nome, sum(o.valor) FROM VendaProdutoFaturamento o WHERE o.vendaProduto.excluida = false AND o.vendaProduto.faturado = true AND o.vendaProduto.movimentoCaixa.id = :movimentoCaixaId GROUP BY o.condicaoRecebimento.id")
    public List<Object[]> listaPorCaixaFood(@Param(value="movimentoCaixaId") Long var1);

    @Query(value="SELECT o.condicaoRecebimento.nome, sum(o.valor) FROM VendaProdutoFaturamento o WHERE o.vendaProduto.excluida = false AND o.vendaProduto.faturado = true AND o.vendaProduto.dataEmissao between :inicio and :fim GROUP BY o.condicaoRecebimento.id ORDER BY o.condicaoRecebimento.ordem")
    public List<Object[]> listaPorPeriodo(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2);

    @Query(value="SELECT o.condicaoRecebimento.nome, sum(o.valor) FROM VendaProdutoFaturamento o WHERE o.vendaProduto.excluida = false AND o.vendaProduto.faturado = true AND o.vendaProduto.dataEmissao between :inicio and :fim AND o.vendaProduto.vendedor.id = :vendedorId GROUP BY o.condicaoRecebimento.id ORDER BY o.condicaoRecebimento.ordem")
    public List<Object[]> listaPorPeriodo(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="vendedorId") Long var3);
}

