/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepositoryCustom;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface VendaProdutoItemRepository
extends JpaRepository<VendaProdutoItem, Long>,
VendaProdutoItemRepositoryCustom {
    @Query(value="SELECT o FROM VendaProdutoItem o WHERE o.pedidoItem.id = :pedidoItemId")
    public VendaProdutoItem getByPedidoItem(@Param(value="pedidoItemId") Long var1);

    @Query(value="SELECT o FROM VendaProdutoItem o WHERE o.ativo = true AND o.vendaProduto.id = :vendaProdutoId ORDER BY o.numItem ASC")
    public List<VendaProdutoItem> listaPorVenda(@Param(value="vendaProdutoId") long var1);

    @Query(value="SELECT o FROM VendaProdutoItem o WHERE o.ativo = true AND o.vendaProduto.id = :vendaProdutoId ORDER BY o.produto.categoriaProduto.nome, o.produto.nome ASC")
    public List<VendaProdutoItem> listaPorVendaOrderByCategoria(@Param(value="vendaProdutoId") long var1);

    @Query(value="SELECT o.produto.codigo, o.produto.categoriaProduto.nome, o.descricao, o.unidade, sum(o.quantidade), avg(o.precoUnitario), sum(o.precoTotal) FROM VendaProdutoItem o WHERE o.ativo = true AND (o.vendaProduto.dataEmissao BETWEEN :dataInicio AND :dataFim) AND o.vendaProduto.excluida = false GROUP BY o.produto.id ORDER BY sum(o.precoTotal) DESC")
    public List<Object[]> listaVendidos(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT o.produto.codigo, o.produto.categoriaProduto.nome, o.descricao, o.unidade, sum(o.quantidade), avg(o.precoUnitario), sum(o.precoTotal) FROM VendaProdutoItem o WHERE o.ativo = true AND o.produto.categoriaProduto.id = :categoriaId AND (o.vendaProduto.dataEmissao BETWEEN :dataInicio AND :dataFim) AND o.vendaProduto.excluida = false GROUP BY o.produto.id ORDER BY sum(o.precoTotal) DESC")
    public List<Object[]> listaVendidos(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="categoriaId") long var3);

    @Query(value="SELECT o.produto.categoriaProduto.nome, sum(o.quantidade), sum(o.precoTotal) FROM VendaProdutoItem o WHERE o.ativo = true AND o.vendaProduto.excluida = false AND (o.vendaProduto.dataEmissao BETWEEN :dataInicio AND :dataFim) GROUP BY o.produto.categoriaProduto.id ORDER BY sum(o.precoTotal) DESC")
    public List<Object[]> vendidosCategorias(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT sum(o.precoTotal) FROM VendaProdutoItem o WHERE o.ativo = true AND (o.vendaProduto.dataEmissao BETWEEN :dataInicio AND :dataFim)")
    public BigDecimal somaVendidos(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT sum(o.precoTotal) FROM VendaProdutoItem o WHERE o.ativo = true AND o.produto.categoriaProduto.id = :categoriaId AND (o.vendaProduto.dataEmissao BETWEEN :dataInicio AND :dataFim)")
    public BigDecimal somaVendidos(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="categoriaId") long var3);

    @Query(value="SELECT o.produto.categoriaProduto.id, o.descricao, sum(o.quantidade), avg(o.precoUnitario), sum(o.precoTotal), o.produto.id FROM VendaProdutoItem o WHERE o.ativo = true AND o.vendaProduto.excluida = false AND o.vendaProduto.movimentoCaixa.id = :movimentoCaixaId AND o.vendaProduto.faturado = true GROUP BY o.produto.id, o.brinde ORDER BY o.produto.nome")
    public List<Object[]> listaVendidos(@Param(value="movimentoCaixaId") Long var1);

    @Query(value="SELECT sum(o.quantidade) FROM VendaProdutoItem o WHERE o.ativo = true AND o.vendaProduto.excluida = false AND o.vendaProduto.faturado = true AND o.vendaProduto.movimentoCaixa.id = :movimentoCaixaId ORDER BY o.produto.nome")
    public Long quantidadeItensVendidos(@Param(value="movimentoCaixaId") Long var1);

    @Query(value="SELECT avg(o.precoUnitario) FROM VendaProdutoItem o WHERE o.ativo = true AND o.vendaProduto.excluida = false AND o.vendaProduto.faturado = true AND o.vendaProduto.movimentoCaixa.id = :movimentoCaixaId ORDER BY o.produto.nome")
    public BigDecimal ticketItensVendidos(@Param(value="movimentoCaixaId") Long var1);

    @Query(value="SELECT vpi FROM VendaProdutoItem vpi WHERE vpi.vendaProduto.excluida = false AND vpi.ativo = true AND vpi.produto.id = :produtoId ORDER BY vpi.vendaProduto.dataEmissao DESC")
    public List<VendaProdutoItem> vendasPorProduto(@Param(value="produtoId") long var1);
}

