/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.bean.VendaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepositoryCustom;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public class VendaProdutoItemRepositoryCustomImpl
implements VendaProdutoItemRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public List<Object[]> relatorio(LocalDate inicio, LocalDate fim, Boolean faturado, Cliente cliente, Vendedor vendedor, CategoriaProduto categoriaProduto, Boolean agruparProdutos, VendaProdutoItemOrderBy orderBy) {
        String order;
        String hql;
        if (agruparProdutos.booleanValue()) {
            hql = "SELECT o.produto.codigo, o.produto.categoriaProduto.nome, o.descricao, o.unidade, sum(o.quantidade), avg(o.precoUnitario), sum(o.precoTotal), sum(o.desconto), o.precoCusto, o.servicoCusto, o.produto.id, sum((o.precoCusto + o.servicoCusto) * o.quantidade), o.produto.estoqueAtual FROM VendaProdutoItem o WHERE (o.vendaProduto.dataEmissao between :inicio and :fim) AND o.vendaProduto.excluida = false AND o.ativo = true";
            order = " GROUP BY o.produto.id ORDER BY o.produto.nome ASC";
        } else {
            hql = "SELECT o.produto.codigo, o.produto.categoriaProduto.nome, o.descricao, o.unidade, o.quantidade, o.precoUnitario, o.precoTotal, o.desconto, o.precoCusto, o.servicoCusto, o.produto.id, o.vendaProduto.id, o.vendaProduto.dataEmissao, o.produto.estoqueAtual FROM VendaProdutoItem o WHERE (o.vendaProduto.dataEmissao between :inicio and :fim) AND o.vendaProduto.excluida = false AND o.ativo = true";
            order = orderBy.equals((Object)VendaProdutoItemOrderBy.DESCRICAO) || orderBy.equals((Object)VendaProdutoItemOrderBy.MAIS_VENDIDOS) ? " ORDER BY o.produto.nome ASC" : " ORDER BY o.vendaProduto.dataEmissao ASC";
        }
        String where = "";
        if (faturado != null && faturado.booleanValue()) {
            where = where + " AND o.vendaProduto.faturado = true ";
        }
        if (cliente != null) {
            where = where + " AND o.vendaProduto.cliente.id = " + cliente.getId() + " ";
        }
        if (vendedor != null) {
            where = where + " AND (o.vendedor.id = " + vendedor.getId() + " or o.vendaProduto.vendedor.id = " + vendedor.getId() + ")";
        }
        if (categoriaProduto != null) {
            where = where + " AND o.produto.categoriaProduto.id = " + categoriaProduto.getId() + " ";
        }
        return this.entityManager.createQuery(hql + where + order).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }

    public List<Object[]> relatorioAgrupado(LocalDate inicio, LocalDate fim, Boolean faturado, Vendedor vendedor) {
        String hql = "SELECT o.produto.codigo, o.produto.categoriaProduto.nome, o.descricao, o.unidade, sum(o.quantidade), avg(o.precoUnitario), sum(o.precoTotal), sum(o.desconto), avg(o.precoCusto), avg(o.servicoCusto), o.produto.id, sum((o.precoCusto + o.servicoCusto) * o.quantidade), o.produto.estoqueAtual FROM VendaProdutoItem o WHERE (o.vendaProduto.dataEmissao between :inicio and :fim) AND o.vendaProduto.excluida = false AND o.ativo = true";
        String order = " GROUP BY o.produto.id ORDER BY o.produto.categoriaProduto.nome, o.produto.nome ASC";
        String where = "";
        if (faturado != null && faturado.booleanValue()) {
            where = where + " AND o.vendaProduto.faturado = true ";
        }
        if (vendedor != null) {
            where = where + " AND (o.vendedor.id = " + vendedor.getId() + " or o.vendaProduto.vendedor.id = " + vendedor.getId() + ")";
        }
        return this.entityManager.createQuery(hql + where + order).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }

    public List<Object[]> relatorioAgrupadoCliente(LocalDate inicio, LocalDate fim, Boolean faturado, Cliente cliente) {
        String hql = "SELECT o.produto.codigo, o.produto.categoriaProduto.nome, o.descricao, o.unidade, sum(o.quantidade), avg(o.precoUnitario), sum(o.precoTotal), sum(o.desconto), avg(o.precoCusto), avg(o.servicoCusto), o.produto.id, sum((o.precoCusto + o.servicoCusto) * o.quantidade), o.produto.estoqueAtual FROM VendaProdutoItem o WHERE (o.vendaProduto.dataEmissao between :inicio and :fim) AND o.vendaProduto.excluida = false AND o.ativo = true";
        String order = " GROUP BY o.produto.id ORDER BY o.produto.categoriaProduto.nome, o.produto.nome ASC";
        String where = "";
        if (faturado != null && faturado.booleanValue()) {
            where = where + " AND o.vendaProduto.faturado = true ";
        }
        if (cliente != null) {
            where = where + " AND (o.vendaProduto.cliente.id = " + cliente.getId() + ")";
        }
        return this.entityManager.createQuery(hql + where + order).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }
}

