/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.PedidoStatus;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoTipo;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepositoryCustom;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface VendaProdutoRepository
extends JpaRepository<VendaProduto, Long>,
VendaProdutoRepositoryCustom {
    @Query(value="SELECT o FROM VendaProduto o WHERE o.pedido.id = :pedidoId")
    public VendaProduto getByPedido(@Param(value="pedidoId") Long var1);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.faturado = true AND o.movimentoCaixa.id = :caixaId ORDER BY o.dataEmissao DESC, o.id DESC")
    public List<VendaProduto> listaPorMovimentoCaixa(@Param(value="caixaId") long var1);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.movimentoCaixa.id = :caixaId ORDER BY o.dataEmissao DESC, o.id DESC")
    public List<VendaProduto> listaPorMovimentoCaixaSemFaturar(@Param(value="caixaId") long var1);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.tipo = :tipo AND o.cliente.nome like :filtro ORDER BY o.id DESC")
    public List<VendaProduto> listaCondicional(@Param(value="tipo") VendaProdutoTipo var1, @Param(value="filtro") String var2);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.pedido.pedidoStatus = :pedidoStatus AND o.cliente.nome like :filtro ORDER BY o.id DESC")
    public List<VendaProduto> listaEmEntrega(@Param(value="pedidoStatus") PedidoStatus var1, @Param(value="filtro") String var2);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.faturado = true AND (o.dataEmissao between :inicio and :fim) and o.cliente.nome like :filtro  ORDER BY o.dataEmissao DESC, o.id DESC")
    public List<VendaProduto> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.faturado = true AND (o.dataEmissao between :inicio and :fim) and o.cliente.id = :clienteId  ORDER BY o.dataEmissao DESC, o.cliente.nome ASC")
    public List<VendaProduto> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="clienteId") Long var3);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.faturado = false AND (o.dataEmissao between :inicio and :fim) and o.cliente.nome like :filtro  ORDER BY o.dataEmissao DESC, o.id DESC")
    public List<VendaProduto> emAberto(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT SUM(o.total) FROM VendaProduto o WHERE o.excluida = false AND o.faturado = true AND (o.dataEmissao between :inicio and :fim) and o.cliente.nome like :filtro  ORDER BY o.dataEmissao DESC, o.id DESC")
    public BigDecimal total(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT SUM(o.total) FROM VendaProduto o WHERE o.excluida = false AND o.faturado = true AND (o.dataEmissao between :inicio and :fim)")
    public BigDecimal total(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.contaReceber.id = :contaReceberId")
    public VendaProduto getByContaReceber(@Param(value="contaReceberId") Long var1);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.entradaProduto.id = :entradaProdutoId")
    public VendaProduto getByEntradaProduto(@Param(value="entradaProdutoId") Long var1);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.nfce.id = :nfceId")
    public VendaProduto getByNFCe(@Param(value="nfceId") Long var1);

    @Query(value="SELECT o.dataEmissao, sum(o.total) FROM VendaProduto o WHERE o.excluida = false AND o.faturado = true AND (o.dataEmissao between :inicio and :fim) GROUP BY o.dataEmissao ORDER BY o.dataEmissao")
    public List<Object[]> grafico(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2);

    @Modifying
    @Query(value="UPDATE VendaProduto o SET o.finalizada = true WHERE o.finalizada is null")
    public void setFinalizada();

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.dataEmissao >= :dataEmissao ORDER BY o.dataEmissao")
    public List<VendaProduto> listaAtualizacao(@Param(value="dataEmissao") LocalDate var1, Pageable var2);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND (o.sincronizadoErp is null or o.sincronizadoErp = false)  ORDER BY o.id ASC")
    public List<VendaProduto> listaSincronizarErp(Pageable var1);

    @Query(value="SELECT count(o.id) FROM VendaProduto o WHERE o.excluida = false AND o.faturado = true AND o.movimentoCaixa.id = :movimentoCaixaId ORDER BY o.id")
    public Long quantidadeVendasPorCaixa(@Param(value="movimentoCaixaId") long var1);

    @Query(value="SELECT avg(o.total) FROM VendaProduto o WHERE o.excluida = false AND o.faturado = true AND o.movimentoCaixa.id = :movimentoCaixaId ORDER BY o.id")
    public BigDecimal ticketMedioPorCaixa(@Param(value="movimentoCaixaId") long var1);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.id in (SELECT vpi.vendaProduto.id FROM VendaProdutoItem vpi WHERE vpi.ativo = true AND vpi.produto.id = :produtoId) ORDER BY o.dataEmissao DESC")
    public List<VendaProduto> vendasPorProduto(@Param(value="produtoId") long var1);

    @Query(value="SELECT o FROM VendaProduto o WHERE o.excluida = false AND o.movimentoCaixa.id = :movimentoCaixaId ORDER BY o.id DESC")
    public List<VendaProduto> getUltimaUpdate(@Param(value="movimentoCaixaId") Long var1, Pageable var2);
}

