/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioVendaProdutoPorDiaBean;
import br.com.maximasolutions.estoque.relatorio.dto.VendaProdutoGraficoDto;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepositoryCustom;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

public class VendaProdutoRepositoryCustomImpl
implements VendaProdutoRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public VendaProduto getUltima(Long caixa) {
        try {
            if (caixa == null) {
                return (VendaProduto)this.entityManager.createQuery("SELECT o FROM VendaProduto o WHERE o.excluida = FALSE ORDER BY o.id DESC").setMaxResults(1).getSingleResult();
            }
            return (VendaProduto)this.entityManager.createQuery("SELECT o FROM VendaProduto o WHERE o.excluida = FALSE AND o.movimentoCaixa.caixa.id = :caixaId ORDER BY o.id DESC").setParameter("caixaId", (Object)caixa).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<VendaProduto> pesquisa(LocalDate inicio, LocalDate fim, Boolean faturado, Boolean excluida, String filtro) {
        String hql = "SELECT o FROM VendaProduto o WHERE (o.dataEmissao between :inicio and :fim) and o.cliente.nome like '%" + filtro + "%'";
        String where = "";
        if (faturado == null || !faturado.booleanValue()) {
            where = where + " AND o.faturado = false ";
        }
        where = excluida != null && excluida != false ? where + " AND o.excluida = true " : where + " AND o.excluida = false ";
        String orderBy = " ORDER BY o.dataEmissao DESC, o.id DESC";
        return this.entityManager.createQuery(hql + where + orderBy).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }

    public BigDecimal totalPesquisa(LocalDate inicio, LocalDate fim, Boolean faturado, Boolean excluida, String filtro) {
        String hql = "SELECT SUM(o.total) FROM VendaProduto o WHERE (o.dataEmissao between :inicio and :fim) and o.cliente.nome like '%" + filtro + "%'";
        String where = "";
        if (faturado == null || !faturado.booleanValue()) {
            where = where + " AND o.faturado = false ";
        }
        where = excluida != null && excluida != false ? where + " AND o.excluida = true " : where + " AND o.excluida = false ";
        return (BigDecimal)this.entityManager.createQuery(hql + where).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getSingleResult();
    }

    public BigDecimal liquidoPesquisa(LocalDate inicio, LocalDate fim, Boolean faturado, Boolean excluida, String filtro) {
        String hql = "SELECT SUM(o.totalLiquido) FROM VendaProduto o WHERE o.finalizada = true AND (o.dataEmissao between :inicio and :fim) and o.cliente.nome like '%" + filtro + "%'";
        String where = "";
        if (faturado == null || !faturado.booleanValue()) {
            where = where + " AND o.faturado = false ";
        }
        where = excluida != null && excluida != false ? where + " AND o.excluida = true " : where + " AND o.excluida = false ";
        return (BigDecimal)this.entityManager.createQuery(hql + where).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getSingleResult();
    }

    public List<VendaProduto> relatorio(LocalDate inicio, LocalDate fim, Boolean faturado, Cliente cliente, Vendedor vendedor) {
        String hql = "SELECT o FROM VendaProduto o WHERE (o.dataEmissao between :inicio and :fim) AND o.excluida = false ";
        String where = "";
        if (faturado != null && faturado.booleanValue()) {
            where = where + " AND o.faturado = true ";
        }
        if (cliente != null) {
            where = where + " AND o.cliente.id = " + cliente.getId() + " ";
        }
        if (vendedor != null) {
            where = where + " AND o.vendedor.id = " + vendedor.getId() + " ";
        }
        String orderBy = " ORDER BY o.dataEmissao DESC, o.cliente.nome";
        return this.entityManager.createQuery(hql + where + orderBy).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }

    public List<RelatorioVendaProdutoPorDiaBean> relatorio(LocalDate inicio, LocalDate fim, Vendedor vendedor) {
        String hql = "SELECT o.dataEmissao, sum(o.total), sum(o.totalLiquido) FROM VendaProduto o WHERE (o.dataEmissao between :inicio and :fim) AND o.excluida = false ";
        String where = "";
        if (vendedor != null) {
            where = where + " AND o.vendedor.id = " + vendedor.getId() + " ";
        }
        String orderBy = " GROUP BY o.dataEmissao ORDER BY o.dataEmissao";
        List retorno = this.entityManager.createQuery(hql + where + orderBy).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
        ArrayList<RelatorioVendaProdutoPorDiaBean> lista = new ArrayList<RelatorioVendaProdutoPorDiaBean>();
        retorno.forEach(obj -> {
            BigDecimal total = (BigDecimal)obj[1];
            BigDecimal liquido = (BigDecimal)obj[2];
            lista.add(new RelatorioVendaProdutoPorDiaBean((LocalDate)obj[0], total, liquido));
        });
        return lista;
    }

    public int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public List<VendaProdutoGraficoDto> grafico(LocalDate inicio, LocalDate fim, Boolean faturado, Cliente cliente) {
        String hql = "SELECT new br.com.maximasolutions.estoque.relatorio.dto.VendaProdutoGraficoDto(o.dataEmissao, sum(o.total)) FROM VendaProduto o WHERE (o.dataEmissao between :inicio and :fim) AND o.excluida = false ";
        String where = "";
        if (faturado != null && faturado.booleanValue()) {
            where = where + " AND o.faturado = true ";
        }
        if (cliente != null) {
            where = where + " AND o.cliente.id = " + cliente.getId() + " ";
        }
        String orderBy = " GROUP BY o.dataEmissao ORDER BY o.dataEmissao ASC";
        return this.entityManager.createQuery(hql + where + orderBy).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }
}

