/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.BaixaProduto;
import br.com.maximasolutions.estoque.modelo.BaixaProdutoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoExtrato;
import br.com.maximasolutions.estoque.modelo.ProdutoExtratoTipo;
import br.com.maximasolutions.estoque.report.BaixaProdutoReport;
import br.com.maximasolutions.estoque.repository.BaixaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.BaixaProdutoRepository;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoExtratoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.service.BaixaProdutoService;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class BaixaProdutoServiceImpl
implements BaixaProdutoService {
    @Autowired
    private BaixaProdutoRepository baixaProdutoRepository;
    @Autowired
    private BaixaProdutoItemRepository baixaProdutoItemRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoExtratoRepository produtoExtratoRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;

    @Transactional(readOnly=true)
    public BaixaProduto getById(Long id) {
        Optional baixaProduto = this.baixaProdutoRepository.findById((Object)id);
        if (!baixaProduto.isPresent()) {
            return null;
        }
        return (BaixaProduto)baixaProduto.get();
    }

    public BaixaProduto salva(BaixaProduto baixaProduto, List<BaixaProdutoItem> itens) throws MaximaException {
        System.out.println("--- baixa produto obse: " + baixaProduto.getObservacao());
        baixaProduto = (BaixaProduto)this.baixaProdutoRepository.save((Object)baixaProduto);
        BigDecimal totalCusto = BigDecimal.ZERO;
        BigDecimal totalVenda = BigDecimal.ZERO;
        for (BaixaProdutoItem item : itens) {
            ProdutoExtrato produtoExtrato;
            Produto produto = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            BigDecimal quantidade = item.getQuantidade();
            if (item.getId() == null) {
                if (!item.getExcluido().booleanValue()) {
                    item.setBaixaProduto(baixaProduto);
                    item = (BaixaProdutoItem)this.baixaProdutoItemRepository.save((Object)item);
                    produto.setEstoqueAtual(produto.getEstoqueAtual().subtract(quantidade));
                    produto = (Produto)this.produtoRepository.save((Object)produto);
                    produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "BAIXA [" + baixaProduto.getId() + "]", MaximaNumber.negativa((BigDecimal)quantidade), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.BAIXA_PRODUTO_ADD);
                    this.produtoExtratoRepository.save((Object)produtoExtrato);
                }
            } else if (item.getExcluido().booleanValue()) {
                item.setAtivo(Boolean.FALSE);
                item = (BaixaProdutoItem)this.baixaProdutoItemRepository.save((Object)item);
                produto.setEstoqueAtual(produto.getEstoqueAtual().add(quantidade));
                produto = (Produto)this.produtoRepository.save((Object)produto);
                produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "BAIXA [" + baixaProduto.getId() + "]", quantidade, "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.BAIXA_PRODUTO_DELETE);
                this.produtoExtratoRepository.save((Object)produtoExtrato);
            }
            if (item.getExcluido().booleanValue()) continue;
            totalCusto = totalCusto.add(item.getTotalCusto());
            totalVenda = totalVenda.add(item.getTotalVenda());
        }
        baixaProduto.setTotalCusto(totalCusto);
        baixaProduto.setTotalVenda(totalVenda);
        return (BaixaProduto)this.baixaProdutoRepository.save((Object)baixaProduto);
    }

    public BaixaProduto delete(BaixaProduto baixaProduto) throws MaximaException {
        if ((baixaProduto = (BaixaProduto)this.baixaProdutoRepository.findById((Object)baixaProduto.getId()).get()).getExcluida().booleanValue()) {
            throw new MaximaException("Baixa de produto j\u00e1 removida.");
        }
        baixaProduto.setExcluida(Boolean.TRUE);
        baixaProduto.setDataExclusao(LocalDateTime.now());
        baixaProduto = (BaixaProduto)this.baixaProdutoRepository.save((Object)baixaProduto);
        List itens = this.baixaProdutoItemRepository.lista(baixaProduto.getId().longValue());
        for (BaixaProdutoItem item : itens) {
            Produto produto = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            BigDecimal quantidade = item.getQuantidade();
            produto.setEstoqueAtual(produto.getEstoqueAtual().add(quantidade));
            produto = (Produto)this.produtoRepository.save((Object)produto);
            ProdutoExtrato produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "BAIXA [" + baixaProduto.getId() + "]", quantidade, "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.BAIXA_PRODUTO_DELETE);
            this.produtoExtratoRepository.save((Object)produtoExtrato);
        }
        return baixaProduto;
    }

    @Transactional(readOnly=true)
    public List<BaixaProdutoItem> listItens(BaixaProduto baixaProduto) {
        return this.baixaProdutoItemRepository.lista(baixaProduto.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<BaixaProduto> lista(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        return this.baixaProdutoRepository.pesquisa(inicio, fim, excluida, filtro);
    }

    @Transactional(readOnly=true)
    public void imprime(BaixaProduto baixaProduto) throws MaximaException {
        if (baixaProduto.getExcluida().booleanValue()) {
            throw new MaximaException("Baixa de produto exclu\u00eddo. N\u00e3o pode ser impresso.");
        }
        List itemLista = this.baixaProdutoItemRepository.lista(baixaProduto.getId().longValue());
        new BaixaProdutoReport(this.configuracaoRepository.load()).visualiza(baixaProduto, itemLista);
    }
}

