/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.CategoriaProdutoTamanho;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.repository.CategoriaProdutoRepository;
import br.com.maximasolutions.estoque.repository.CategoriaProdutoTamanhoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class CategoriaProdutoServiceImpl
implements CategoriaProdutoService {
    @Autowired
    private CategoriaProdutoRepository categoriaProdutoRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private CategoriaProdutoTamanhoRepository categoriaProdutoTamanhoRepository;

    @Transactional(readOnly=true)
    public List<CategoriaProduto> list() {
        return this.categoriaProdutoRepository.list();
    }

    @Transactional(readOnly=true)
    public List<CategoriaProduto> listaTodas() {
        return this.categoriaProdutoRepository.pesquisa("");
    }

    @Transactional(readOnly=true)
    public CategoriaProduto load(long id) {
        Optional categoriaProduto = this.categoriaProdutoRepository.findById((Object)id);
        if (categoriaProduto.isPresent()) {
            return (CategoriaProduto)categoriaProduto.get();
        }
        return null;
    }

    public CategoriaProduto save(CategoriaProduto categoriaProduto) throws MaximaException {
        categoriaProduto.setSincronizado(Boolean.FALSE);
        return (CategoriaProduto)this.categoriaProdutoRepository.save((Object)categoriaProduto);
    }

    public CategoriaProduto save(CategoriaProduto categoriaProduto, List<CategoriaProdutoTamanho> tamanhos) throws MaximaException {
        categoriaProduto.setSincronizado(Boolean.FALSE);
        categoriaProduto = (CategoriaProduto)this.categoriaProdutoRepository.save((Object)categoriaProduto);
        int cont = 0;
        for (CategoriaProdutoTamanho tam : tamanhos) {
            tam.setNumeroItem(Integer.valueOf(++cont));
            tam.setCategoriaProduto(categoriaProduto);
            this.categoriaProdutoTamanhoRepository.save((Object)tam);
        }
        return categoriaProduto;
    }

    public void deleteById(Long id) {
        CategoriaProduto categoriaProduto = (CategoriaProduto)this.categoriaProdutoRepository.getOne((Object)id);
        categoriaProduto.setAtivo(Boolean.FALSE);
        this.categoriaProdutoRepository.save((Object)categoriaProduto);
        List produtos = this.produtoRepository.lista(categoriaProduto, null);
        for (Produto produto : produtos) {
            produto.setAtivo(Boolean.valueOf(true));
            this.produtoRepository.save((Object)produto);
        }
    }

    @Transactional(readOnly=true)
    public List<CategoriaProduto> pesquisa(String valor) {
        return this.categoriaProdutoRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public List<CategoriaProduto> combo() {
        ArrayList<CategoriaProduto> lista = new ArrayList<CategoriaProduto>();
        lista.add(null);
        lista.addAll(this.categoriaProdutoRepository.list());
        return lista;
    }

    @Transactional(readOnly=true)
    public List<CategoriaProdutoTamanho> listaCategoriaProdutoTamanhos(Long categoriaId) {
        ArrayList<CategoriaProdutoTamanho> lista = new ArrayList();
        lista = this.categoriaProdutoTamanhoRepository.listaCategoriaProdutoTamanhos(categoriaId);
        return lista;
    }

    public CategoriaProdutoTamanho deleteTamanho(Long tamanhoId) {
        CategoriaProdutoTamanho tamanho = (CategoriaProdutoTamanho)this.categoriaProdutoTamanhoRepository.getOne((Object)tamanhoId);
        tamanho.setAtivo(Boolean.valueOf(false));
        return (CategoriaProdutoTamanho)this.categoriaProdutoTamanhoRepository.save((Object)tamanho);
    }

    @Transactional(readOnly=true)
    public List<CategoriaProduto> listaSincronizar() {
        return this.categoriaProdutoRepository.sincronizar();
    }
}

