/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.ImpressoraModelo;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.Consignado;
import br.com.maximasolutions.estoque.modelo.ConsignadoItem;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.repository.ConsignadoItemRepository;
import br.com.maximasolutions.estoque.repository.ConsignadoRepository;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.geral.modelo.Cliente;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class ConsignadoService {
    private final ConsignadoRepository consignadoRepository;
    private final ConsignadoItemRepository consignadoItemRepository;
    private final PedidoRepository pedidoRepository;
    private final PedidoItemRepository pedidoItemRepository;
    private final ConfiguracaoRepository configuracaoRepository;

    public ConsignadoService(ConsignadoRepository consignadoRepository, ConsignadoItemRepository consignadoItemRepository, PedidoRepository pedidoRepository, PedidoItemRepository pedidoItemRepository, ConfiguracaoRepository configuracaoRepository) {
        this.consignadoRepository = consignadoRepository;
        this.consignadoItemRepository = consignadoItemRepository;
        this.pedidoRepository = pedidoRepository;
        this.pedidoItemRepository = pedidoItemRepository;
        this.configuracaoRepository = configuracaoRepository;
    }

    public Consignado salva(Pedido pedido, Cliente cliente) throws MaximaException {
        pedido = (Pedido)this.pedidoRepository.findById((Object)pedido.getId()).get();
        if (cliente != null) {
            pedido.setCliente(cliente);
        }
        if (pedido.getExcluido().booleanValue()) {
            throw new MaximaException("Aviso: Pedido exclu\u00eddo.\nOr\u00e7amento n\u00e3o finalizado.");
        }
        pedido.setFinalizado(Boolean.TRUE);
        pedido.setUltimaAlteracao(LocalDateTime.now());
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        Consignado consignado = this.consignadoRepository.getByPedido(pedido.getId());
        consignado = this.createConsignado(consignado, pedido);
        consignado = (Consignado)this.consignadoRepository.save((Object)consignado);
        List pedidoItens = this.pedidoItemRepository.itensAll(pedido.getId());
        for (PedidoItem pedidoItem : pedidoItens) {
            ConsignadoItem consignadoItem = this.consignadoItemRepository.getByPedidoItem(pedidoItem.getId());
            if (pedidoItem.getExcluido().booleanValue()) {
                if (consignadoItem == null || !consignadoItem.isAtivo().booleanValue()) continue;
                consignadoItem.setAtivo(Boolean.FALSE);
                consignadoItem.setDataExclusao(LocalDateTime.now());
                this.consignadoItemRepository.save((Object)consignadoItem);
                continue;
            }
            if (consignadoItem != null && pedidoItem.getEditado().booleanValue()) {
                consignadoItem.setPrecoUnitario(pedidoItem.getPrecoUnitario());
                consignadoItem.setDesconto(pedidoItem.getDesconto());
                consignadoItem.setQuantidade(pedidoItem.getQuantidade());
                consignadoItem.setPrecoTotal(pedidoItem.getPrecoTotal());
                consignadoItem.setObservacao(pedidoItem.getObservacao());
                consignadoItem = (ConsignadoItem)this.consignadoItemRepository.save((Object)consignadoItem);
                pedidoItem.setEditado(Boolean.FALSE);
                this.pedidoItemRepository.save((Object)pedidoItem);
            }
            if (consignadoItem != null) continue;
            consignadoItem = this.createConsignadoItem(consignadoItem, pedidoItem, consignado);
            consignadoItem = (ConsignadoItem)this.consignadoItemRepository.save((Object)consignadoItem);
        }
        return consignado;
    }

    @Transactional(readOnly=true)
    public Consignado getById(long id) {
        Optional consignado = this.consignadoRepository.findById((Object)id);
        if (!consignado.isPresent()) {
            return null;
        }
        return (Consignado)consignado.get();
    }

    @Transactional(readOnly=true)
    public List<Consignado> lista(LocalDate dataInicio, LocalDate dataFinal, String filtro) {
        return this.consignadoRepository.lista(dataInicio, dataFinal, "%" + filtro + "%");
    }

    @Transactional(readOnly=true)
    public List<ConsignadoItem> itens(Consignado consignado) {
        return this.consignadoItemRepository.listaItens(consignado.getId().longValue());
    }

    private Consignado createConsignado(Consignado consignado, Pedido pedido) {
        if (consignado == null || consignado.getId() == null) {
            consignado = new Consignado();
        }
        consignado.setAcrescimo(pedido.getAcrescimo());
        consignado.setAtivo(Boolean.TRUE);
        consignado.setCliente(pedido.getCliente());
        consignado.setDataEmissao(pedido.getDataEmissao());
        consignado.setDataOperacao(LocalDateTime.now());
        consignado.setDesconto(pedido.getDesconto());
        consignado.setExcluida(Boolean.FALSE);
        consignado.setObservacao(pedido.getObservacao());
        consignado.setTotal(pedido.getTotal());
        consignado.setValorProdutos(pedido.getValorProdutos());
        consignado.setValorServicos(pedido.getValorServico());
        consignado.setValorPecas(pedido.getValorPecas());
        consignado.setCustoPecas(pedido.getCustoProdutos());
        consignado.setCustoServicos(pedido.getCustoServicos());
        consignado.setCustoTotal(pedido.getCustoTotal());
        consignado.setVendedor(pedido.getVendedor());
        consignado.setPedido(pedido);
        return consignado;
    }

    private ConsignadoItem createConsignadoItem(ConsignadoItem consignadoItem, PedidoItem item, Consignado consignado) {
        if (consignadoItem == null) {
            consignadoItem = new ConsignadoItem();
        }
        consignadoItem.setAtivo(Boolean.TRUE);
        consignadoItem.setDataMovimento(LocalDateTime.now());
        consignadoItem.setDesconto(item.getDesconto());
        consignadoItem.setDescricao(item.getDescricao());
        consignadoItem.setNumItem(item.getNumItem());
        consignadoItem.setObservacao(item.getObservacao());
        consignadoItem.setPrecoCusto(item.getPrecoCusto());
        if (item.getProduto().getServico().booleanValue()) {
            consignadoItem.setServicoCusto(item.getServicoCusto());
            consignadoItem.setPrecoCusto(BigDecimal.ZERO);
        } else {
            consignadoItem.setPrecoCusto(item.getPrecoCusto());
            consignadoItem.setServicoCusto(BigDecimal.ZERO);
        }
        consignadoItem.setPrecoTotal(item.getPrecoTotal());
        consignadoItem.setPrecoUnitario(item.getPrecoUnitario());
        consignadoItem.setProduto(item.getProduto());
        consignadoItem.setQuantidade(item.getQuantidade());
        consignadoItem.setUnidade(item.getUnidade());
        consignadoItem.setConsignado(consignado);
        consignadoItem.setPedidoItem(item);
        return consignadoItem;
    }

    public void delete(Consignado consignado) throws MaximaException {
        consignado.setAtivo(Boolean.FALSE);
        consignado.setExcluida(Boolean.TRUE);
        this.consignadoRepository.save((Object)consignado);
    }

    public void imprime(Consignado consignado) throws MaximaException {
        if ((consignado = (Consignado)this.consignadoRepository.findById((Object)consignado.getId()).get()).isExcluida().booleanValue() || consignado.getFinalizado().booleanValue()) {
            throw new MaximaException("Or\u00e7amento exclu\u00eddo ou finalizado. N\u00e3o pode ser impresso.");
        }
        List consignadoItemLista = this.consignadoItemRepository.listaItens(consignado.getId().longValue());
        Configuracao conf = this.configuracaoRepository.load();
        ImpressoraModelo impressoraModelo = conf.getImpressoraModelo();
        throw new MaximaException("M\u00e9todo n\u00e3o implementado!!!");
    }
}

