/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.bean.EntradaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.bean.RelatorioEntradaProdutoItemBean;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrima;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrimaItem;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.modelo.MateriaPrimaExtrato;
import br.com.maximasolutions.estoque.modelo.MateriaPrimaExtratoTipo;
import br.com.maximasolutions.estoque.repository.EntradaMateriaPrimaItemRepository;
import br.com.maximasolutions.estoque.repository.EntradaMateriaPrimaRepository;
import br.com.maximasolutions.estoque.repository.MateriaPrimaExtratoRepository;
import br.com.maximasolutions.estoque.repository.MateriaPrimaRepository;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.estoque.service.EntradaMateriaPrimaService;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.fiscal.sped.bean.BlocoCRegistro190;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.utils.MaximaNumber;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class EntradaMateriaPrimaServiceImpl
implements EntradaMateriaPrimaService {
    @Autowired
    private EntradaMateriaPrimaRepository entradaMateriaPrimaRepository;
    @Autowired
    private EntradaMateriaPrimaItemRepository entradaMateriaPrimaItemRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private MateriaPrimaRepository produtoRepository;
    @Autowired
    private MateriaPrimaExtratoRepository produtoExtratoRepository;

    @Transactional(readOnly=true)
    public EntradaMateriaPrima getById(Long id) {
        Optional entradaMateriaPrima = this.entradaMateriaPrimaRepository.findById((Object)id);
        if (!entradaMateriaPrima.isPresent()) {
            return null;
        }
        return (EntradaMateriaPrima)entradaMateriaPrima.get();
    }

    public List<EntradaMateriaPrimaItem> itens(EntradaMateriaPrima entradaMateriaPrima) {
        return this.entradaMateriaPrimaItemRepository.lista(entradaMateriaPrima.getId().longValue());
    }

    @Transactional(readOnly=true)
    public EntradaMateriaPrima getByChaveAcesso(String chaveAcesso) {
        return this.entradaMateriaPrimaRepository.getByChaveAcesso(chaveAcesso);
    }

    public EntradaMateriaPrima salva(EntradaMateriaPrima entradaMateriaPrima, List<EntradaMateriaPrimaItem> itens) throws MaximaException {
        entradaMateriaPrima = (EntradaMateriaPrima)this.entradaMateriaPrimaRepository.save((Object)entradaMateriaPrima);
        BigDecimal valorMateriaPrimas = BigDecimal.ZERO;
        for (EntradaMateriaPrimaItem item : itens) {
            BigDecimal estoqueAnterior;
            MateriaPrima materiaPrima;
            if (item.getId() == null) {
                if (!item.getExcluido().booleanValue()) {
                    item.setEntradaMateriaPrima(entradaMateriaPrima);
                    item = (EntradaMateriaPrimaItem)this.entradaMateriaPrimaItemRepository.save((Object)item);
                    materiaPrima = (MateriaPrima)this.produtoRepository.findById((Object)item.getMateriaPrima().getId()).get();
                    estoqueAnterior = materiaPrima.getEstoqueAtual();
                    BigDecimal precoCusto = item.getPrecoCusto();
                    if (materiaPrima.getUnidadeEntrada() != null && !materiaPrima.getUnidadeEntrada().getId().equals(materiaPrima.getUnidade().getId())) {
                        if (materiaPrima.getFatorConversaoEntrada() != null && materiaPrima.getFatorConversaoEntrada().compareTo(BigDecimal.ZERO) != 0) {
                            materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().add(item.getQuantidade().multiply(materiaPrima.getFatorConversaoEntrada())));
                            precoCusto = precoCusto.divide(materiaPrima.getFatorConversaoEntrada(), 2, RoundingMode.HALF_EVEN);
                        } else {
                            materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().add(item.getQuantidade()));
                        }
                    } else {
                        materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().add(item.getQuantidade()));
                    }
                    materiaPrima.setUltimoCusto(precoCusto);
                    materiaPrima = (MateriaPrima)this.produtoRepository.save((Object)materiaPrima);
                    MateriaPrimaExtrato produtoExtrato = new MateriaPrimaExtrato(materiaPrima, LocalDate.now(), item.getQuantidade(), "", estoqueAnterior, materiaPrima.getEstoqueAtual(), MateriaPrimaExtratoTipo.COMPRA);
                    this.produtoExtratoRepository.save((Object)produtoExtrato);
                }
            } else if (item.getExcluido().booleanValue()) {
                item.setAtivo(Boolean.FALSE);
                item = (EntradaMateriaPrimaItem)this.entradaMateriaPrimaItemRepository.save((Object)item);
                materiaPrima = (MateriaPrima)this.produtoRepository.findById((Object)item.getMateriaPrima().getId()).get();
                estoqueAnterior = materiaPrima.getEstoqueAtual();
                if (materiaPrima.getUnidadeEntrada() != null && !materiaPrima.getUnidadeEntrada().getId().equals(materiaPrima.getUnidade().getId())) {
                    if (materiaPrima.getFatorConversaoEntrada() != null || materiaPrima.getFatorConversaoEntrada().compareTo(BigDecimal.ZERO) != 0) {
                        materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().add(item.getQuantidade().multiply(materiaPrima.getFatorConversaoEntrada())));
                    } else {
                        materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().add(item.getQuantidade()));
                    }
                } else {
                    materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().add(item.getQuantidade()));
                }
                materiaPrima = (MateriaPrima)this.produtoRepository.save((Object)materiaPrima);
                MateriaPrimaExtrato produtoExtrato = new MateriaPrimaExtrato(materiaPrima, LocalDate.now(), MaximaNumber.negativa((BigDecimal)item.getQuantidade()), "", estoqueAnterior, materiaPrima.getEstoqueAtual(), MateriaPrimaExtratoTipo.COMPRA_DELETE);
                this.produtoExtratoRepository.save((Object)produtoExtrato);
            }
            if (item.getExcluido().booleanValue()) continue;
            valorMateriaPrimas = valorMateriaPrimas.add(item.getTotalCusto());
        }
        entradaMateriaPrima.setValorProdutos(valorMateriaPrimas);
        entradaMateriaPrima.setTotal(valorMateriaPrimas);
        return (EntradaMateriaPrima)this.entradaMateriaPrimaRepository.save((Object)entradaMateriaPrima);
    }

    public EntradaMateriaPrima delete(EntradaMateriaPrima entradaMateriaPrima) throws MaximaException {
        if ((entradaMateriaPrima = (EntradaMateriaPrima)this.entradaMateriaPrimaRepository.findById((Object)entradaMateriaPrima.getId()).get()).getExcluida().booleanValue()) {
            throw new MaximaException("Entrada de produto j\u00e1 removida.");
        }
        entradaMateriaPrima.setExcluida(Boolean.TRUE);
        entradaMateriaPrima.setDataExclusao(LocalDateTime.now());
        entradaMateriaPrima = (EntradaMateriaPrima)this.entradaMateriaPrimaRepository.save((Object)entradaMateriaPrima);
        List itens = this.entradaMateriaPrimaItemRepository.lista(entradaMateriaPrima.getId().longValue());
        for (EntradaMateriaPrimaItem item : itens) {
            MateriaPrima materiaPrima = (MateriaPrima)this.produtoRepository.findById((Object)item.getMateriaPrima().getId()).get();
            BigDecimal estoqueAnterior = materiaPrima.getEstoqueAtual();
            if (materiaPrima.getUnidadeEntrada() != null && !materiaPrima.getUnidadeEntrada().getId().equals(materiaPrima.getUnidade().getId())) {
                if (materiaPrima.getFatorConversaoEntrada() != null || materiaPrima.getFatorConversaoEntrada().compareTo(BigDecimal.ZERO) != 0) {
                    materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().subtract(item.getQuantidade().multiply(materiaPrima.getFatorConversaoEntrada())));
                } else {
                    materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().subtract(item.getQuantidade()));
                }
            } else {
                materiaPrima.setEstoqueAtual(materiaPrima.getEstoqueAtual().subtract(item.getQuantidade()));
            }
            materiaPrima = (MateriaPrima)this.produtoRepository.save((Object)materiaPrima);
            MateriaPrimaExtrato produtoExtrato = new MateriaPrimaExtrato(materiaPrima, LocalDate.now(), MaximaNumber.negativa((BigDecimal)item.getQuantidade()), "", estoqueAnterior, materiaPrima.getEstoqueAtual(), MateriaPrimaExtratoTipo.COMPRA_DELETE);
            this.produtoExtratoRepository.save((Object)produtoExtrato);
        }
        return entradaMateriaPrima;
    }

    @Transactional(readOnly=true)
    public List<EntradaMateriaPrimaItem> listSpedItens(EntradaMateriaPrima entradaMateriaPrima) {
        return this.entradaMateriaPrimaItemRepository.lista(entradaMateriaPrima.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<EntradaMateriaPrima> lista(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        return this.entradaMateriaPrimaRepository.pesquisa(inicio, fim, excluida, filtro);
    }

    public BigDecimal totalLista(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        return this.entradaMateriaPrimaRepository.totalPesquisa(inicio, fim, excluida, filtro);
    }

    public List<Fornecedor> listaSpedFornecedores(LocalDate inicio, LocalDate fim) {
        return this.entradaMateriaPrimaRepository.listaSpedFornecedores(inicio, fim);
    }

    public List<String> listaSpedTipoUnidades(LocalDate inicio, LocalDate fim) {
        List unidades = this.entradaMateriaPrimaItemRepository.listaSpedTipoUnidade(inicio, fim);
        List lista = this.entradaMateriaPrimaItemRepository.listaSpedMateriaPrimaUnidades(inicio, fim);
        for (String un : lista) {
            Boolean existe = false;
            for (String unEntrada : unidades) {
                if (!un.equalsIgnoreCase(unEntrada)) continue;
                existe = true;
                break;
            }
            if (existe.booleanValue()) continue;
            unidades.add(un);
        }
        return unidades;
    }

    public List<MateriaPrima> listaSpedMateriaPrima(LocalDate inicio, LocalDate fim) {
        return this.entradaMateriaPrimaItemRepository.listaSpedMateriaPrima(inicio, fim);
    }

    public List<EntradaMateriaPrima> listaSped(LocalDate inicio, LocalDate fim) {
        return this.entradaMateriaPrimaRepository.listaSped(inicio, fim);
    }

    public List<BlocoCRegistro190> listaSpedRegistro190(EntradaMateriaPrima emp) {
        List lista = this.entradaMateriaPrimaItemRepository.listaSpedRegistro190(emp.getId().longValue());
        ArrayList<BlocoCRegistro190> retorno = new ArrayList<BlocoCRegistro190>();
        lista.forEach(obj -> {
            BlocoCRegistro190 c190 = new BlocoCRegistro190();
            System.out.println("EMPPPPPPPPPPPPPPPPPP: " + emp.getId());
            c190.setCst(((NFNotaInfoImpostoTributacaoICMS)obj[0]).getCodigo());
            c190.setCfop(String.valueOf(obj[1]));
            c190.setAliquotaIcms((BigDecimal)obj[2]);
            c190.setValorOperacao((BigDecimal)obj[3]);
            c190.setBaseCalculoIcms((BigDecimal)obj[4]);
            c190.setValorIcms((BigDecimal)obj[5]);
            c190.setBaseCalculoIcmsST((BigDecimal)obj[6]);
            c190.setValorIcmsST((BigDecimal)obj[7]);
            c190.setReducaoBaseCalculo((BigDecimal)obj[8]);
            c190.setValorIpi((BigDecimal)obj[9]);
            retorno.add(c190);
        });
        return retorno;
    }

    public BigDecimal valorIcmsSped(LocalDate inicio, LocalDate fim) {
        BigDecimal valorIcms = this.entradaMateriaPrimaRepository.valorIcmsSped(inicio, fim);
        if (valorIcms == null) {
            valorIcms = BigDecimal.ZERO;
        }
        return valorIcms;
    }

    public List<RelatorioEntradaProdutoItemBean> relatorioProdutos(LocalDate inicio, LocalDate fim, Fornecedor fornecedor, Boolean agruparProdutos, EntradaProdutoItemOrderBy orderBy) {
        List lista = this.entradaMateriaPrimaItemRepository.relatorio(inicio, fim, fornecedor, agruparProdutos, orderBy);
        ArrayList<RelatorioEntradaProdutoItemBean> retorno = new ArrayList<RelatorioEntradaProdutoItemBean>();
        for (Object[] obj : lista) {
            RelatorioEntradaProdutoItemBean bean = new RelatorioEntradaProdutoItemBean();
            bean.setCodigo((String)obj[0]);
            bean.setProduto((String)obj[1]);
            bean.setQuantidade((BigDecimal)obj[3]);
            try {
                bean.setValorMedio(new BigDecimal((Double)obj[4]));
            }
            catch (Exception e) {
                bean.setValorMedio((BigDecimal)obj[4]);
            }
            bean.setTotal((BigDecimal)obj[5]);
            bean.setProdutoId((Long)obj[7]);
            bean.setUnidade((String)obj[9]);
            LocalDate dataCompra = null;
            if (obj.length == 11) {
                dataCompra = (LocalDate)obj[10];
                bean.setDataCompra(dataCompra.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            }
            retorno.add(bean);
        }
        return retorno;
    }
}

