/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.ImpressoraModelo;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaImpressao;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.Orcamento;
import br.com.maximasolutions.estoque.modelo.OrcamentoItem;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.printer.OrcamentoPrinter;
import br.com.maximasolutions.estoque.report.OrcamentoReport;
import br.com.maximasolutions.estoque.repository.OrcamentoItemRepository;
import br.com.maximasolutions.estoque.repository.OrcamentoRepository;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.estoque.service.OrcamentoService;
import br.com.maximasolutions.estoque.service.VendaProdutoServiceImpl;
import br.com.maximasolutions.geral.modelo.Cliente;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class OrcamentoServiceImpl
implements OrcamentoService {
    @Autowired
    private OrcamentoRepository orcamentoRepository;
    @Autowired
    private OrcamentoItemRepository orcamentoItemRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;

    public Orcamento salva(Pedido pedido, Cliente cliente) throws MaximaException {
        pedido = (Pedido)this.pedidoRepository.findById((Object)pedido.getId()).get();
        if (cliente != null) {
            pedido.setCliente(cliente);
        }
        if (pedido.getExcluido().booleanValue()) {
            throw new MaximaException("Aviso: Pedido exclu\u00eddo.\nOr\u00e7amento n\u00e3o finalizado.");
        }
        pedido.setFinalizado(Boolean.TRUE);
        pedido.setUltimaAlteracao(LocalDateTime.now());
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        Orcamento orcamento = this.orcamentoRepository.getByPedido(pedido.getId());
        orcamento = this.createOrcamento(orcamento, pedido);
        orcamento = (Orcamento)this.orcamentoRepository.save((Object)orcamento);
        List pedidoItens = this.pedidoItemRepository.itensAll(pedido.getId());
        for (PedidoItem pedidoItem : pedidoItens) {
            OrcamentoItem orcamentoItem = this.orcamentoItemRepository.getByPedidoItem(pedidoItem.getId());
            if (orcamentoItem != null) {
                orcamentoItem.setDescricao(pedidoItem.getDescricao());
            }
            if (pedidoItem.getExcluido().booleanValue()) {
                if (orcamentoItem == null || !orcamentoItem.isAtivo().booleanValue()) continue;
                orcamentoItem.setAtivo(Boolean.FALSE);
                orcamentoItem.setDataExclusao(LocalDateTime.now());
                this.orcamentoItemRepository.save((Object)orcamentoItem);
                continue;
            }
            if (orcamentoItem != null && pedidoItem.getEditado().booleanValue()) {
                orcamentoItem.setPrecoUnitario(pedidoItem.getPrecoUnitario());
                orcamentoItem.setDesconto(pedidoItem.getDesconto());
                orcamentoItem.setQuantidade(pedidoItem.getQuantidade());
                orcamentoItem.setPrecoTotal(pedidoItem.getPrecoTotal());
                orcamentoItem.setObservacao(pedidoItem.getObservacao());
                orcamentoItem = (OrcamentoItem)this.orcamentoItemRepository.save((Object)orcamentoItem);
                pedidoItem.setEditado(Boolean.FALSE);
                this.pedidoItemRepository.save((Object)pedidoItem);
            }
            if (orcamentoItem != null) continue;
            orcamentoItem = this.createOrcamentoItem(orcamentoItem, pedidoItem, orcamento);
            orcamentoItem = (OrcamentoItem)this.orcamentoItemRepository.save((Object)orcamentoItem);
        }
        return orcamento;
    }

    @Transactional(readOnly=true)
    public Orcamento getById(long id) {
        Optional orcamento = this.orcamentoRepository.findById((Object)id);
        if (!orcamento.isPresent()) {
            return null;
        }
        return (Orcamento)orcamento.get();
    }

    @Transactional(readOnly=true)
    public List<Orcamento> lista(LocalDate dataInicio, LocalDate dataFinal, String filtro) {
        return this.orcamentoRepository.lista(dataInicio, dataFinal, "%" + filtro + "%");
    }

    @Transactional(readOnly=true)
    public List<OrcamentoItem> itens(Orcamento orcamento) {
        return this.orcamentoItemRepository.listaItens(orcamento.getId().longValue());
    }

    private Orcamento createOrcamento(Orcamento orcamento, Pedido pedido) {
        if (orcamento == null || orcamento.getId() == null) {
            orcamento = new Orcamento();
        }
        orcamento.setAcrescimo(pedido.getAcrescimo());
        orcamento.setAtivo(Boolean.TRUE);
        orcamento.setCliente(pedido.getCliente());
        orcamento.setDataEmissao(pedido.getDataEmissao());
        orcamento.setDataOperacao(LocalDateTime.now());
        orcamento.setDesconto(pedido.getDesconto());
        orcamento.setExcluida(Boolean.FALSE);
        orcamento.setObservacao(pedido.getObservacao());
        orcamento.setTotal(pedido.getTotal());
        orcamento.setValorProdutos(pedido.getValorProdutos());
        orcamento.setValorServicos(pedido.getValorServico());
        orcamento.setValorPecas(pedido.getValorPecas());
        orcamento.setCustoPecas(pedido.getCustoProdutos());
        orcamento.setCustoServicos(pedido.getCustoServicos());
        orcamento.setCustoTotal(pedido.getCustoTotal());
        orcamento.setVendedor(pedido.getVendedor());
        orcamento.setPedido(pedido);
        return orcamento;
    }

    private OrcamentoItem createOrcamentoItem(OrcamentoItem orcamentoItem, PedidoItem item, Orcamento orcamento) {
        if (orcamentoItem == null) {
            orcamentoItem = new OrcamentoItem();
        }
        orcamentoItem.setAtivo(Boolean.TRUE);
        orcamentoItem.setDataMovimento(LocalDateTime.now());
        orcamentoItem.setDesconto(item.getDesconto());
        orcamentoItem.setDescricao(item.getDescricao());
        orcamentoItem.setNumItem(item.getNumItem());
        orcamentoItem.setObservacao(item.getObservacao());
        orcamentoItem.setPrecoCusto(item.getPrecoCusto());
        if (item.getProduto().getServico().booleanValue()) {
            orcamentoItem.setServicoCusto(item.getServicoCusto());
            orcamentoItem.setPrecoCusto(BigDecimal.ZERO);
        } else {
            orcamentoItem.setPrecoCusto(item.getPrecoCusto());
            orcamentoItem.setServicoCusto(BigDecimal.ZERO);
        }
        orcamentoItem.setPrecoTotal(item.getPrecoTotal());
        orcamentoItem.setPrecoUnitario(item.getPrecoUnitario());
        orcamentoItem.setProduto(item.getProduto());
        orcamentoItem.setQuantidade(item.getQuantidade());
        orcamentoItem.setUnidade(item.getUnidade());
        orcamentoItem.setOrcamento(orcamento);
        orcamentoItem.setPedidoItem(item);
        return orcamentoItem;
    }

    public void delete(Orcamento orcamento) throws MaximaException {
        orcamento.setAtivo(Boolean.FALSE);
        orcamento.setExcluida(Boolean.TRUE);
        this.orcamentoRepository.save((Object)orcamento);
    }

    @Transactional(readOnly=true)
    public void imprime(Orcamento orcamento) throws MaximaException {
        if ((orcamento = (Orcamento)this.orcamentoRepository.findById((Object)orcamento.getId()).get()).isExcluida().booleanValue() || orcamento.getFinalizado().booleanValue()) {
            throw new MaximaException("Or\u00e7amento exclu\u00eddo ou finalizado. N\u00e3o pode ser impresso.");
        }
        List orcamentoItemLista = this.orcamentoItemRepository.listaItens(orcamento.getId().longValue());
        Configuracao conf = this.configuracaoRepository.load();
        ImpressoraModelo impressoraModelo = conf.getImpressoraModelo();
        if (impressoraModelo.equals((Object)ImpressoraModelo.A4)) {
            new OrcamentoReport(this.configuracaoRepository.load()).visualiza(orcamento, orcamentoItemLista);
            return;
        }
        String textoImprime = OrcamentoPrinter.modeloMaior((Orcamento)orcamento, (List)orcamentoItemLista, (Configuracao)conf);
        try {
            new MaximaImpressao(conf).printText(textoImprime);
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(VendaProdutoServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException(ex.getMessage());
        }
    }
}

