/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaDescontoException;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.Orcamento;
import br.com.maximasolutions.estoque.modelo.OrcamentoItem;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.PedidoStatus;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoComposicao;
import br.com.maximasolutions.estoque.modelo.PromocaoProduto;
import br.com.maximasolutions.estoque.modelo.TipoMovimentacao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.repository.OrcamentoItemRepository;
import br.com.maximasolutions.estoque.repository.OrcamentoRepository;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoComposicaoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.food.modelo.Comanda;
import br.com.maximasolutions.food.repository.MesaRepository;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class PedidoServiceImpl
implements PedidoService {
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    @Autowired
    private OrcamentoRepository orcamentoRepository;
    @Autowired
    private ProdutoComposicaoRepository produtoComposicaoRepository;
    @Autowired
    private OrcamentoItemRepository orcamentoItemRepository;
    @Autowired
    private MesaRepository mesaRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;

    @Transactional(readOnly=true)
    public Pedido getById(Long id) {
        Optional pedido = this.pedidoRepository.findById((Object)id);
        if (!pedido.isPresent()) {
            return null;
        }
        return (Pedido)pedido.get();
    }

    public Pedido salva(Pedido pedido) {
        return (Pedido)this.pedidoRepository.save((Object)pedido);
    }

    public Pedido inicia(Vendedor vendedor, Cliente cliente, LocalDate dataEmissao, TipoMovimentacao tipoMovimentacao, String ordemCompra, Boolean comTroca) throws MaximaException {
        try {
            Pedido pedido = this.novo(vendedor, cliente, dataEmissao, tipoMovimentacao, ordemCompra);
            pedido.setComTroca(comTroca);
            pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
            return pedido;
        }
        catch (Exception e) {
            Logger.getLogger(PedidoServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel iniciar o pedido.\nCausa: " + e.getLocalizedMessage());
        }
    }

    public Pedido inicia(Vendedor vendedor, Cliente cliente, LocalDate dataEmissao, TipoMovimentacao tipoMovimentacao, String ordemCompra) throws MaximaException {
        try {
            MovimentoCaixa movimentoCaixa = this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")));
            if (movimentoCaixa == null) {
                throw new MaximaException("Aviso: Nenhum movimento de caixa aberto.");
            }
            Pedido pedido = this.novo(vendedor, cliente, dataEmissao, tipoMovimentacao, ordemCompra);
            pedido.setMovimentoCaixa(movimentoCaixa);
            pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
            return pedido;
        }
        catch (Exception e) {
            Logger.getLogger(PedidoServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel iniciar o pedido.\nCausa: " + e.getLocalizedMessage());
        }
    }

    public Pedido addItem(Pedido pedido, Vendedor vendedor, Produto produto, BigDecimal quantidade, BigDecimal precoUnitario, BigDecimal desconto, String observacao, Boolean brinde, Boolean troca) throws MaximaException {
        try {
            pedido = (Pedido)this.pedidoRepository.findById((Object)pedido.getId()).get();
        }
        catch (Exception e) {
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel recuperar os dados do pedido.\nCausa: " + e.getLocalizedMessage());
        }
        if (pedido.getExcluido().booleanValue()) {
            throw new MaximaException("Aviso: Pedido j\u00e1 exclu\u00eddo.");
        }
        if (desconto == null) {
            desconto = BigDecimal.ZERO;
        }
        BigDecimal totalItem = quantidade.multiply(precoUnitario).setScale(2, RoundingMode.HALF_EVEN).subtract(desconto);
        produto = (Produto)this.produtoRepository.findById((Object)produto.getId()).get();
        if (quantidade.compareTo(BigDecimal.ZERO) > 0 && quantidade.compareTo(produto.getQuantidadeMinimaVenda()) < 0) {
            throw new MaximaException("AVISO: Quantidade m\u00ednima para venda deste produto: " + MaximaNumber.quantidadeToString((BigDecimal)produto.getQuantidadeMinimaVenda()));
        }
        Configuracao conf = this.configuracaoService.load();
        if (!conf.getPermiteEstoqueNegativo().booleanValue() && produto.isEstoqueNegativo().booleanValue() && produto.getEstoqueAtual().compareTo(quantidade) < 0) {
            throw new MaximaException("AVISO: Estoque insuficiente!");
        }
        if (quantidade.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal valorMinimoPermitido;
            BigDecimal descontoMaximoPermitido = produto.getDescontoPermitido();
            if (conf.getDescontoAtualPermitido().compareTo(descontoMaximoPermitido) > 0) {
                descontoMaximoPermitido = conf.getDescontoAtualPermitido();
            }
            if (desconto != null && desconto.compareTo(BigDecimal.ZERO) > 0) {
                if (produto.getDescontoPermitido().compareTo(BigDecimal.ZERO) <= 0 && conf.getDescontoAtualPermitido().compareTo(BigDecimal.ZERO) <= 0) {
                    throw new MaximaException("Aviso: O valor do desconto informado n\u00e3o \u00e9 permitido para este produto.");
                }
                BigDecimal precoTotalCadastro = produto.getPrecoVenda().multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
                BigDecimal valorMinimoPermitido2 = precoTotalCadastro.subtract(precoTotalCadastro.multiply(descontoMaximoPermitido).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN));
                if (totalItem.compareTo(valorMinimoPermitido2) < 0) {
                    throw new MaximaException("AVISO: Valor unit\u00e1rio e/ou desconto menor que o valor permitido.");
                }
            } else if (precoUnitario.compareTo(produto.getPrecoVenda()) < 0 && precoUnitario.compareTo(valorMinimoPermitido = produto.getPrecoVenda().subtract(produto.getPrecoVenda().multiply(descontoMaximoPermitido).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN))) < 0) {
                throw new MaximaException("AVISO: Valor unit\u00e1rio menor que o valor permitido.");
            }
        }
        try {
            PedidoItem item = this.novoItem(this.getNumeroItem(pedido), pedido, vendedor, produto, quantidade, precoUnitario, desconto, totalItem, observacao, brinde);
            if (troca != null && troca.booleanValue() && MaximaConfig.getDino().booleanValue()) {
                item.setDescricao("(TROCA) " + item.getDescricao());
                item.setTrocaDino(Boolean.valueOf(true));
            }
            item = (PedidoItem)this.pedidoItemRepository.save((Object)item);
            return (Pedido)this.pedidoRepository.save((Object)this.atualizaPedido((Pedido)this.pedidoRepository.findById((Object)item.getPedido().getId()).get()));
        }
        catch (Exception e) {
            Logger.getLogger(PedidoServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel adicionar o produto.\nCausa: " + e.getLocalizedMessage());
        }
    }

    public Pedido deleteItem(PedidoItem item) throws MaximaException {
        try {
            item = (PedidoItem)this.pedidoItemRepository.findById((Object)item.getId()).get();
            if (item.getExcluido().booleanValue()) {
                throw new MaximaException("Item j\u00e1 exclu\u00eddo do pedido.");
            }
            item.setExcluido(Boolean.TRUE);
            item.setDataExclusao(LocalDateTime.now());
            item = (PedidoItem)this.pedidoItemRepository.save((Object)item);
            List itens = this.pedidoItemRepository.itens(item.getPedido().getId());
            int numItem = 1;
            for (PedidoItem i : itens) {
                i.setNumItem(Integer.valueOf(numItem));
                this.pedidoItemRepository.save((Object)i);
                ++numItem;
            }
            return (Pedido)this.pedidoRepository.save((Object)this.atualizaPedido((Pedido)this.pedidoRepository.findById((Object)item.getPedido().getId()).get()));
        }
        catch (MaximaException e) {
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel excluir o produto.\nCausa: " + e.getLocalizedMessage());
        }
    }

    public Pedido editaItem(PedidoItem item, Vendedor vendedor, BigDecimal precoUnitario, BigDecimal quantidade, BigDecimal desconto, BigDecimal frete, String observacao) throws MaximaException {
        try {
            BigDecimal valorPermitido;
            item = (PedidoItem)this.pedidoItemRepository.findById((Object)item.getId()).get();
            if (item.getExcluido().booleanValue()) {
                throw new MaximaException("Item j\u00e1 exclu\u00eddo do pedido.");
            }
            if (desconto == null) {
                desconto = BigDecimal.ZERO;
            }
            if (frete == null) {
                frete = BigDecimal.ZERO;
            }
            if (frete.compareTo(BigDecimal.ZERO) < 0) {
                throw new MaximaException("O valor do frete deve ser um valor maior que zero.");
            }
            Configuracao conf = this.configuracaoService.load();
            Produto produto = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
            BigDecimal descontoMaximoPermitido = produto.getDescontoPermitido();
            if (conf.getDescontoAtualPermitido().compareTo(descontoMaximoPermitido) > 0) {
                descontoMaximoPermitido = conf.getDescontoAtualPermitido();
            }
            BigDecimal totalItem = quantidade.multiply(precoUnitario).setScale(2, RoundingMode.HALF_EVEN).subtract(desconto);
            if (desconto != null && desconto.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal precoTotalCadastro = produto.getPrecoVenda().multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
                BigDecimal valorMinimoPermitido = precoTotalCadastro.subtract(precoTotalCadastro.multiply(descontoMaximoPermitido).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN));
                if (totalItem.compareTo(valorMinimoPermitido) < 0) {
                    throw new MaximaException("AVISO: Valor unit\u00e1rio e/ou desconto menor que o valor permitido.");
                }
            } else if (precoUnitario.compareTo(produto.getPrecoVenda()) < 0 && precoUnitario.compareTo(valorPermitido = produto.getPrecoVenda().subtract(produto.getPrecoVenda().multiply(descontoMaximoPermitido).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN))) < 0) {
                throw new MaximaException("AVISO: Valor unit\u00e1rio menor que o valor permitido.");
            }
            totalItem = totalItem.add(frete);
            item.setVendedor(vendedor);
            item.setPrecoUnitario(precoUnitario);
            item.setQuantidade(quantidade);
            item.setDesconto(desconto);
            item.setFrete(frete);
            if (totalItem.compareTo(BigDecimal.ZERO) <= 0) {
                throw new MaximaException("AVISO: O valor total do item deve ser maior que zero.");
            }
            item.setPrecoTotal(totalItem);
            item.setObservacao(observacao);
            item.setEditado(Boolean.valueOf(true));
            item = (PedidoItem)this.pedidoItemRepository.save((Object)item);
            return (Pedido)this.pedidoRepository.save((Object)this.atualizaPedido((Pedido)this.pedidoRepository.findById((Object)item.getPedido().getId()).get()));
        }
        catch (MaximaException e) {
            throw new MaximaException(e.getLocalizedMessage());
        }
    }

    public Pedido finalizaEntrega(Pedido pedido) throws MaximaException {
        pedido.setPedidoStatus(PedidoStatus.FINALIZADO);
        return (Pedido)this.pedidoRepository.save((Object)pedido);
    }

    @Transactional(readOnly=true)
    public List<PedidoItem> itens(Pedido pedido) {
        return this.pedidoItemRepository.itens(pedido.getId());
    }

    public void cancela(Pedido pedido) throws MaximaException {
        VendaProduto vendaProduto;
        try {
            pedido = (Pedido)this.pedidoRepository.findById((Object)pedido.getId()).get();
        }
        catch (Exception e) {
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel recuperar os dados do pedido.\nCausa: " + e.getLocalizedMessage());
        }
        if (pedido.getExcluido().booleanValue()) {
            throw new MaximaException("Aviso: Pedido j\u00e1 exclu\u00eddo.");
        }
        pedido.setExcluido(Boolean.TRUE);
        pedido.setDataExclusao(LocalDateTime.now());
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        this.pedidoItemRepository.deletePedido(pedido.getId());
        if (pedido.getTipoMovimentacao() != null && (pedido.getTipoMovimentacao().equals((Object)TipoMovimentacao.PEDIDO_VENDA) || pedido.getTipoMovimentacao().equals((Object)TipoMovimentacao.CONDICIONAL)) && (vendaProduto = this.vendaProdutoService.getByPedido(pedido.getId())) != null) {
            this.vendaProdutoService.delete(vendaProduto);
        }
        if (pedido.getComanda() != null) {
            Comanda comanda = (Comanda)this.mesaRepository.findById((Object)pedido.getComanda().getId()).get();
            comanda.setOcupado(Boolean.valueOf(false));
            this.mesaRepository.save((Object)comanda);
        }
    }

    private void validaComboAdd(PedidoItem pedidoItem) {
        Produto produto = pedidoItem.getProduto();
        List combos = this.produtoComposicaoRepository.getCombo(produto.getId());
        if (combos == null || combos.isEmpty()) {
            return;
        }
        for (ProdutoComposicao combo : combos) {
            List subProdutos = this.produtoComposicaoRepository.lista(combo.getProduto().getId());
            for (ProdutoComposicao sub : subProdutos) {
                System.out.println("== SUB: " + sub.getSubProduto().getNome() + ": " + sub.getQuantidade());
            }
        }
    }

    private void validaPromocaoAdd(PromocaoProduto promocaoProduto, Pedido pedido, PedidoItem pedidoItem) {
        List itensPromocao = this.pedidoItemRepository.itensPromocao(pedido.getId(), promocaoProduto.getPromocao().getId());
        BigDecimal quantidadeItens = BigDecimal.ZERO;
        BigDecimal totalItens = BigDecimal.ZERO;
        for (PedidoItem pi : itensPromocao) {
            if (!pi.getId().equals(pedidoItem.getId())) {
                quantidadeItens = quantidadeItens.add(pi.getQuantidade());
            }
            totalItens = totalItens.add(pi.getPrecoTotal());
        }
        BigDecimal quantidadeEmAberto = quantidadeItens.remainder(promocaoProduto.getPromocao().getQuantidade()).add(pedidoItem.getQuantidade());
        if (quantidadeEmAberto.compareTo(promocaoProduto.getPromocao().getQuantidade()) >= 0) {
            BigDecimal quantidadePromocoes = quantidadeEmAberto.divide(promocaoProduto.getPromocao().getQuantidade(), 0, RoundingMode.DOWN);
            BigDecimal valorReal = pedidoItem.getProduto().getPrecoVenda().multiply(promocaoProduto.getPromocao().getQuantidade()).setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal desconto = valorReal.subtract(promocaoProduto.getPromocao().getValor()).multiply(quantidadePromocoes);
            pedidoItem.setDesconto(desconto);
            pedidoItem.setPrecoTotal(pedidoItem.getPrecoTotal().subtract(desconto));
            pedidoItem.setPromocao(Boolean.TRUE);
            this.pedidoItemRepository.save((Object)pedidoItem);
        }
    }

    private Pedido atualizaPedido(Pedido pedido) {
        List itens = this.pedidoItemRepository.itens(pedido.getId());
        BigDecimal valorProdutos = BigDecimal.ZERO;
        BigDecimal valorDesconto = BigDecimal.ZERO;
        BigDecimal valorFrete = BigDecimal.ZERO;
        BigDecimal valorTotal = BigDecimal.ZERO;
        BigDecimal valorPecas = BigDecimal.ZERO;
        BigDecimal valorServico = BigDecimal.ZERO;
        BigDecimal custoProdutos = BigDecimal.ZERO;
        BigDecimal custoServicos = BigDecimal.ZERO;
        BigDecimal custoTotal = BigDecimal.ZERO;
        BigDecimal valorDevolucao = BigDecimal.ZERO;
        BigDecimal valorTroca = BigDecimal.ZERO;
        for (PedidoItem item : itens) {
            if (item.getTrocaDino().booleanValue()) {
                System.out.println("-----buceta: " + item.getPrecoTotal());
                valorTroca = valorTroca.add(item.getPrecoTotal());
                continue;
            }
            if (item.getQuantidade().compareTo(BigDecimal.ZERO) > 0) {
                valorProdutos = valorProdutos.add(item.getPrecoTotal().add(item.getDesconto()).subtract(item.getFrete()));
                valorDesconto = valorDesconto.add(item.getDesconto());
                valorFrete = valorFrete.add(item.getFrete());
                custoProdutos = custoProdutos.add(item.getCustoTotalProdutos());
                custoServicos = custoServicos.add(item.getCustoTotalServicos());
                custoTotal = custoTotal.add(item.getCustoTotal());
                if (item.getProduto().getServico().booleanValue()) {
                    valorServico = valorServico.add(item.getPrecoTotal());
                } else {
                    valorPecas = valorPecas.add(item.getPrecoTotal());
                }
            }
            valorTotal = valorTotal.add(item.getPrecoTotal());
            if (item.getQuantidade().compareTo(BigDecimal.ZERO) >= 0) continue;
            valorDevolucao = valorDevolucao.add(item.getPrecoTotal());
        }
        pedido.setFrete(valorFrete);
        pedido.setDesconto(valorDesconto);
        pedido.setValorProdutos(valorProdutos);
        pedido.setTotal(valorTotal);
        pedido.setValorServico(valorServico);
        pedido.setValorPecas(valorPecas);
        pedido.setCustoProdutos(custoProdutos);
        pedido.setCustoServicos(custoServicos);
        pedido.setCustoTotal(custoTotal);
        pedido.setValorDevolucao(valorDevolucao);
        pedido.setValorTroca(valorTroca);
        pedido.setValorReceber(pedido.getTotal().add(valorTroca));
        return pedido;
    }

    private Integer getNumeroItem(Pedido pedido) {
        Long numeroItem = this.pedidoItemRepository.count(pedido.getId());
        if (numeroItem == null) {
            numeroItem = 0L;
        }
        Long l = numeroItem;
        Long l2 = numeroItem = Long.valueOf(numeroItem + 1L);
        return numeroItem.intValue();
    }

    private PedidoItem novoItem(Integer numeroItem, Pedido pedido, Vendedor vendedor, Produto produto, BigDecimal quantidade, BigDecimal precoUnitario, BigDecimal desconto, BigDecimal totalItem, String observacao, Boolean brinde) {
        PedidoItem item = new PedidoItem();
        item.setCodigo(produto.getCodigo());
        item.setDataMovimento(LocalDateTime.now());
        item.setDescricao(produto.getNome().toUpperCase());
        item.setDesconto(desconto);
        item.setExcluido(Boolean.FALSE);
        item.setNumItem(numeroItem);
        item.setPedido(pedido);
        if (!produto.getServico().booleanValue()) {
            item.setPrecoCusto(produto.getUltimoCusto());
        } else {
            item.setServicoCusto(produto.getUltimoCusto());
        }
        item.setBrinde(brinde);
        if (item.getBrinde().booleanValue()) {
            item.setDescricao(item.getDescricao() + " (BRINDE)");
            item.setPrecoTotal(BigDecimal.ZERO);
            item.setPrecoUnitario(BigDecimal.ZERO);
        } else {
            item.setPrecoTotal(totalItem);
            item.setPrecoUnitario(precoUnitario);
        }
        item.setProduto(produto);
        item.setQuantidade(quantidade);
        item.setUnidade(produto.getUnidade().getSigla());
        item.setObservacao(observacao);
        item.setVendedor(vendedor);
        if (item.getQuantidade().compareTo(BigDecimal.ZERO) < 0) {
            item.setTroca(Boolean.valueOf(true));
        }
        return item;
    }

    private Pedido novo(Vendedor vendedor, Cliente cliente, LocalDate dataEmissao, TipoMovimentacao tipoMovimentacao, String ordemCompra) {
        Pedido pedido = new Pedido();
        pedido.setAcrescimo(BigDecimal.ZERO);
        pedido.setCliente(cliente);
        pedido.setDataEmissao(dataEmissao);
        pedido.setDesconto(BigDecimal.ZERO);
        pedido.setExcluido(Boolean.valueOf(false));
        pedido.setFinalizado(Boolean.valueOf(false));
        pedido.setHora(LocalDateTime.now());
        pedido.setObservacao("");
        System.out.println("=== orderm de compra: " + ordemCompra);
        pedido.setOrdemCompra(ordemCompra);
        pedido.setTipoMovimentacao(tipoMovimentacao);
        pedido.setTotal(BigDecimal.ZERO);
        pedido.setUltimaAlteracao(LocalDateTime.now());
        pedido.setValorProdutos(BigDecimal.ZERO);
        pedido.setVendedor(vendedor);
        return pedido;
    }

    public Pedido create(VendaProduto vendaProduto) {
        vendaProduto = (VendaProduto)this.vendaProdutoRepository.findById((Object)vendaProduto.getId()).get();
        Pedido pedido = this.novo(vendaProduto.getVendedor(), vendaProduto.getCliente(), vendaProduto.getDataEmissao(), TipoMovimentacao.PEDIDO_VENDA, "");
        pedido.setDesconto(vendaProduto.getDesconto());
        pedido.setTotal(vendaProduto.getTotal());
        pedido.setValorProdutos(vendaProduto.getValorProdutos());
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        List itens = this.vendaProdutoService.listItens(vendaProduto);
        int count = 1;
        for (VendaProdutoItem item : itens) {
            PedidoItem pi = this.novoItem(Integer.valueOf(count), pedido, item.getVendedor(), item.getProduto(), item.getQuantidade(), item.getPrecoUnitario(), item.getDesconto(), item.getPrecoTotal(), "", item.getBrinde());
            pi = (PedidoItem)this.pedidoItemRepository.save((Object)pi);
            item.setPedidoItem(pi);
            this.vendaProdutoItemRepository.save((Object)item);
            ++count;
        }
        vendaProduto.setPedido(pedido);
        this.vendaProdutoRepository.save((Object)vendaProduto);
        return pedido;
    }

    public Pedido create(Orcamento orcamento) {
        orcamento = (Orcamento)this.orcamentoRepository.findById((Object)orcamento.getId()).get();
        Pedido pedido = this.novo(orcamento.getVendedor(), orcamento.getCliente(), orcamento.getDataEmissao(), TipoMovimentacao.PEDIDO_VENDA, "");
        pedido.setDesconto(orcamento.getDesconto());
        pedido.setTotal(orcamento.getTotal());
        pedido.setValorProdutos(orcamento.getValorProdutos());
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        List itens = this.orcamentoItemRepository.listaItens(orcamento.getId().longValue());
        int count = 1;
        for (OrcamentoItem item : itens) {
            PedidoItem pi = this.novoItem(Integer.valueOf(count), pedido, null, item.getProduto(), item.getQuantidade(), item.getPrecoUnitario(), item.getDesconto(), item.getPrecoTotal(), "", Boolean.valueOf(false));
            pi = (PedidoItem)this.pedidoItemRepository.save((Object)pi);
            item.setPedidoItem(pi);
            this.orcamentoItemRepository.save((Object)item);
            ++count;
        }
        orcamento.setPedido(pedido);
        this.orcamentoRepository.save((Object)orcamento);
        return pedido;
    }

    @Transactional(readOnly=true)
    public PedidoItem getPorNumeroItem(Integer numeroItem, Pedido pedido) {
        return this.pedidoItemRepository.get(numeroItem, pedido.getId());
    }

    @Transactional(readOnly=true)
    public PedidoItem getPorCodigoOuNumeroItem(String valor, Pedido pedido) {
        List itens = this.pedidoItemRepository.itens(pedido.getId());
        PedidoItem retorno = null;
        Integer numeroItem = 0;
        try {
            numeroItem = Integer.parseInt(valor);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (PedidoItem item : itens) {
            if (!item.getCodigo().equalsIgnoreCase(valor)) continue;
            retorno = item;
            break;
        }
        if (retorno != null) {
            return retorno;
        }
        for (PedidoItem item : itens) {
            if (!item.getNumItem().equals(numeroItem)) continue;
            retorno = item;
            break;
        }
        return retorno;
    }

    @Transactional(readOnly=true)
    public Pedido getByComanda(Comanda comanda) {
        return this.pedidoRepository.getByComanda(comanda.getId().longValue());
    }

    public Pedido atualizaDesconto(Pedido pedido, BigDecimal desconto, Boolean permissao) throws MaximaException, MaximaDescontoException {
        if ((pedido = (Pedido)this.pedidoRepository.getOne((Object)pedido.getId())).getExcluido().booleanValue()) {
            throw new MaximaException("AVISO: Pedido j\u00e1 exclu\u00eddo. N\u00e3o pode ser alterado.");
        }
        if (desconto == null) {
            return pedido;
        }
        pedido.setDesconto(desconto);
        pedido.setTotal(pedido.getValorProdutos().subtract(desconto));
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        List itens = this.pedidoItemRepository.itens(pedido.getId());
        BigDecimal percentualDesconto = desconto.multiply(new BigDecimal(100)).divide(pedido.getValorProdutos(), 2, RoundingMode.HALF_EVEN);
        BigDecimal descontoPermitido = this.configuracaoService.load().getDescontoAtualPermitido();
        if (!permissao.booleanValue() && percentualDesconto.compareTo(descontoPermitido) > 0) {
            throw new MaximaDescontoException("AVISO: Desconto maior que o permitido.\nOpera\u00e7\u00e3o n\u00e3o pode ser realizada.");
        }
        if (itens.size() == 1) {
            PedidoItem item = (PedidoItem)itens.get(0);
            item.setDesconto(desconto);
            item.setPrecoTotal(item.getPrecoUnitario().multiply(item.getQuantidade()).subtract(desconto));
            item.setEditado(Boolean.TRUE);
            this.pedidoItemRepository.save((Object)item);
        } else {
            BigDecimal descontoItens = BigDecimal.ZERO;
            int count = 0;
            for (PedidoItem item : itens) {
                BigDecimal totalItem = item.getPrecoUnitario().multiply(item.getQuantidade());
                BigDecimal descontoItem = MaximaNumber.calculaPercentual((BigDecimal)totalItem, (BigDecimal)percentualDesconto);
                descontoItens = descontoItens.add(descontoItem);
                if (++count == itens.size()) {
                    descontoItem = descontoItens.compareTo(desconto) < 0 ? descontoItem.add(desconto.subtract(descontoItens)) : descontoItem.subtract(descontoItens.subtract(desconto));
                }
                item.setDesconto(descontoItem);
                item.setPrecoTotal(totalItem.subtract(descontoItem));
                item.setEditado(Boolean.TRUE);
                this.pedidoItemRepository.save((Object)item);
            }
        }
        return pedido;
    }
}

