/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.controller.ImportacaoProdutoDto;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.bean.ProdutoExtratoDto;
import br.com.maximasolutions.estoque.bean.ProdutoInventarioBean;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoComposicao;
import br.com.maximasolutions.estoque.modelo.ProdutoExtrato;
import br.com.maximasolutions.estoque.modelo.ProdutoExtratoTipo;
import br.com.maximasolutions.estoque.modelo.ProdutoFornecedor;
import br.com.maximasolutions.estoque.modelo.ProdutoFoto;
import br.com.maximasolutions.estoque.modelo.ProdutoIngrediente;
import br.com.maximasolutions.estoque.modelo.ProdutoMva;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioInventarioBean;
import br.com.maximasolutions.estoque.repository.CategoriaProdutoRepository;
import br.com.maximasolutions.estoque.repository.EntradaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.ProdutoComposicaoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoExtratoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoFornecedorRepository;
import br.com.maximasolutions.estoque.repository.ProdutoFotoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoIngredienteRepository;
import br.com.maximasolutions.estoque.repository.ProdutoMvaRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.repository.UnidadeRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class ProdutoServiceImpl
implements ProdutoService {
    @Autowired
    private ProdutoMvaRepository produtoMvaRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoExtratoRepository produtoExtratoRepository;
    @Autowired
    private ProdutoComposicaoRepository produtoComposicaoRepository;
    @Autowired
    private ProdutoIngredienteRepository produtoIngredienteRepository;
    @Autowired
    private ProdutoFotoRepository produtoFotoRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private CategoriaProdutoRepository categoriaProdutoRepository;
    @Autowired
    private UnidadeRepository unidadeRepository;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    @Autowired
    private ProdutoFornecedorRepository produtoFornecedorRepository;
    @Autowired
    private EntradaProdutoItemRepository entradaProdutoItemRepository;

    public void alteraPreco(List<Produto> produtos, BigDecimal novoPrecoVenda) throws MaximaException {
        for (Produto produto : produtos) {
            produto = (Produto)this.produtoRepository.findById((Object)produto.getId()).get();
            BigDecimal novoPreco = produto.getPrecoVenda().add(produto.getPrecoVenda().multiply(novoPrecoVenda.divide(new BigDecimal(100), 2, RoundingMode.HALF_EVEN)));
            produto.setPrecoVenda(novoPreco);
            produto.setUltimaAlteracao(LocalDateTime.now());
            this.produtoRepository.save((Object)produto);
        }
    }

    public Produto importa(ImportacaoProdutoDto produtoDto) throws MaximaException {
        Produto produtoJaCadastrado = this.produtoRepository.getByCodigoBarras(produtoDto.getCodigo());
        if (produtoJaCadastrado != null) {
            throw new MaximaException("== Produto j\u00e1 cadastrado ==");
        }
        CategoriaProduto categoriaProduto = (CategoriaProduto)this.categoriaProdutoRepository.findById((Object)1L).get();
        Unidade unidade = (Unidade)this.unidadeRepository.findById((Object)1L).get();
        Produto produto = produtoDto.converter(categoriaProduto, unidade);
        return (Produto)this.produtoRepository.save((Object)produto);
    }

    public Produto save(Produto produto) throws MaximaException {
        return (Produto)this.produtoRepository.save((Object)produto);
    }

    public Produto salva(Produto produto, List<ProdutoComposicao> subProdutos, List<ProdutoIngrediente> ingredientes, ProdutoFoto foto, ProdutoFoto foto2) throws MaximaException {
        produto.setUltimaAlteracao(LocalDateTime.now());
        Produto existe = this.produtoRepository.getByCodigoBarras(produto.getCodigo());
        if (existe != null) {
            if (produto.getId() == null) {
                throw new MaximaException("C\u00f3digo j\u00e1 cadastrado para outro produto.");
            }
            if (!produto.getId().equals(existe.getId())) {
                throw new MaximaException("C\u00f3digo j\u00e1 cadastrado para outro produto.");
            }
        }
        if (produto.getCodigoEntrada() != null && !produto.getCodigoEntrada().isEmpty()) {
            existe = this.getByCodigoEntrada(produto.getCodigoEntrada());
            System.out.println("== EXISTE: " + existe);
            if (existe != null) {
                if (produto.getId() == null) {
                    throw new MaximaException("C\u00f3digo de entrada j\u00e1 cadastrado para outro produto.");
                }
                if (!produto.getId().equals(existe.getId())) {
                    throw new MaximaException("C\u00f3digo de entrada j\u00e1 cadastrado para outro produto.");
                }
            }
        }
        Boolean produtoNovo = true;
        if (produto.getId() != null && !MaximaConfig.getAlteraEstoque().booleanValue()) {
            produtoNovo = false;
            Produto produtoEstoque = (Produto)this.produtoRepository.findById((Object)produto.getId()).get();
            produto.setEstoqueAtual(produtoEstoque.getEstoqueAtual());
        }
        produto.setSincronizado(Boolean.valueOf(false));
        produto = (Produto)this.produtoRepository.save((Object)produto);
        if (produtoNovo.booleanValue()) {
            ProdutoExtrato extrato = new ProdutoExtrato(produto, LocalDate.now(), String.valueOf(produto.getId()), produto.getEstoqueAtual(), "NOVO", BigDecimal.ZERO, produto.getEstoqueAtual(), ProdutoExtratoTipo.CADASTRO);
            this.produtoExtratoRepository.save((Object)extrato);
        }
        if (subProdutos != null && !subProdutos.isEmpty()) {
            this.produtoComposicaoRepository.delete(produto.getId());
            for (ProdutoComposicao sub : subProdutos) {
                sub.setProduto(produto);
                this.produtoComposicaoRepository.save((Object)sub);
            }
        }
        if (ingredientes != null && !ingredientes.isEmpty()) {
            this.produtoIngredienteRepository.delete(produto.getId());
            for (ProdutoIngrediente ing : ingredientes) {
                ing.setProduto(produto);
                this.produtoIngredienteRepository.save((Object)ing);
            }
        }
        if (foto != null) {
            foto.setProduto(produto);
            foto.setPrincipal(Boolean.valueOf(true));
            this.produtoFotoRepository.save((Object)foto);
        }
        if (foto2 != null) {
            foto2.setPrincipal(Boolean.valueOf(false));
            foto2.setProduto(produto);
            this.produtoFotoRepository.save((Object)foto2);
        }
        return produto;
    }

    public Produto salva(Produto produto, List<Produto> subProdutosTamanho) throws MaximaException {
        produto.setUltimaAlteracao(LocalDateTime.now());
        produto.setPorTamanho(Boolean.TRUE);
        Produto existe = this.produtoRepository.getByCodigoBarras(produto.getCodigo());
        if (existe != null) {
            if (produto.getId() == null) {
                throw new MaximaException("C\u00f3digo j\u00e1 cadastrado para outro produto.");
            }
            if (!produto.getId().equals(existe.getId())) {
                throw new MaximaException("C\u00f3digo j\u00e1 cadastrado para outro produto.");
            }
        }
        if (produto.getCodigoEntrada() != null && !produto.getCodigoEntrada().isEmpty()) {
            existe = this.getByCodigoEntrada(produto.getCodigoEntrada());
            System.out.println("== EXISTE: " + existe);
            if (existe != null) {
                if (produto.getId() == null) {
                    throw new MaximaException("C\u00f3digo de entrada j\u00e1 cadastrado para outro produto.");
                }
                if (!produto.getId().equals(existe.getId())) {
                    throw new MaximaException("C\u00f3digo de entrada j\u00e1 cadastrado para outro produto.");
                }
            }
        }
        Boolean produtoNovo = true;
        if (produto.getId() != null) {
            produtoNovo = false;
            Produto produtoEstoque = (Produto)this.produtoRepository.findById((Object)produto.getId()).get();
            produto.setEstoqueAtual(produtoEstoque.getEstoqueAtual());
        }
        produto.setSincronizado(Boolean.valueOf(false));
        produto = (Produto)this.produtoRepository.save((Object)produto);
        if (produtoNovo.booleanValue()) {
            ProdutoExtrato extrato = new ProdutoExtrato(produto, LocalDate.now(), String.valueOf(produto.getId()), produto.getEstoqueAtual(), "NOVO", BigDecimal.ZERO, produto.getEstoqueAtual(), ProdutoExtratoTipo.CADASTRO);
            this.produtoExtratoRepository.save((Object)extrato);
        }
        if (subProdutosTamanho != null && !subProdutosTamanho.isEmpty()) {
            for (Produto sub : subProdutosTamanho) {
                sub.setProdutoPaiTamanho(produto);
                sub.setNome(sub.getProdutoPaiTamanho().getNome() + " ( " + sub.getCategoriaProdutoTamanho().getDescricao().toUpperCase() + " )");
                this.produtoRepository.save((Object)sub);
            }
        }
        return produto;
    }

    public Produto remove(Produto produto) throws MaximaException {
        produto = (Produto)this.produtoRepository.findById((Object)produto.getId()).get();
        produto.setAtivo(Boolean.valueOf(false));
        produto.setSincronizado(Boolean.valueOf(false));
        produto = (Produto)this.produtoRepository.save((Object)produto);
        if (produto.getProdutoPaiTamanho() != null) {
            Produto produtoTamanho = produto.getProdutoPaiTamanho();
            produtoTamanho.setAtivo(Boolean.valueOf(false));
            produtoTamanho.setSincronizado(Boolean.valueOf(false));
            this.produtoRepository.save((Object)produtoTamanho);
        }
        return produto;
    }

    @Transactional(readOnly=true)
    public Produto getByCodigoBarras(String codigo) {
        return this.produtoRepository.getByCodigoBarras(codigo);
    }

    @Transactional(readOnly=true)
    public List<Produto> listaPorCodigoBarras(String codigo) {
        return this.produtoRepository.listaPorCodigoDeBarras(codigo);
    }

    @Transactional(readOnly=true)
    public List<Produto> getByCodigoInterno(String codigo) {
        return this.produtoRepository.getByCodigoInterno(codigo);
    }

    @Transactional(readOnly=true)
    public Produto getByCodigoEntrada(String codigo) {
        List retorno = this.produtoRepository.getByCodigoEntrada(codigo);
        if (retorno == null || retorno.isEmpty() || retorno.size() > 1) {
            return null;
        }
        return (Produto)retorno.get(0);
    }

    @Transactional(readOnly=true)
    public List<Produto> pesquisa(String filtro) {
        String valor1 = "";
        String valor2 = "";
        if (filtro != null && !filtro.isEmpty()) {
            if (filtro.contains(";")) {
                String[] valores = filtro.split(";");
                valor1 = valores[0];
                if (valores.length > 1) {
                    valor2 = valores[1];
                }
            } else {
                valor1 = filtro;
            }
        }
        return this.produtoRepository.pesquisa("%" + valor1 + "%", valor2);
    }

    @Transactional(readOnly=true)
    public List<Produto> pesquisa(CategoriaProduto categoriaProduto, Boolean ativo, Boolean estoquePositivo, Boolean servico, String filtro) {
        List produtos;
        Produto produto;
        ArrayList<Produto> list = new ArrayList<Produto>();
        Boolean pesquisaTodos = MaximaConfig.getProdutoPesquisaTodos();
        if (!pesquisaTodos.booleanValue()) {
            if (filtro != null && !filtro.isEmpty()) {
                produto = this.produtoRepository.getByCodigoBarras(filtro);
                if (produto != null) {
                    list.add(produto);
                    return list;
                }
                produtos = this.produtoRepository.getByCodigoInterno(filtro);
                if (produtos != null && !produtos.isEmpty()) {
                    list.addAll(produtos);
                    return list;
                }
            }
        } else if (filtro != null && !filtro.isEmpty()) {
            produto = this.produtoRepository.getByCodigoBarras(filtro);
            if (produto != null) {
                list.add(produto);
            } else {
                produtos = this.produtoRepository.getByCodigoInterno(filtro);
                if (produtos != null && !produtos.isEmpty()) {
                    list.addAll(produtos);
                    return list;
                }
            }
        }
        String valor1 = "";
        String valor2 = "";
        if (filtro != null && !filtro.isEmpty()) {
            if (filtro.contains(";")) {
                String[] valores = filtro.split(";");
                valor1 = valores[0];
                if (valores.length > 1) {
                    valor2 = valores[1];
                }
            } else {
                valor1 = filtro;
            }
        }
        List produtos2 = this.produtoRepository.pesquisa(categoriaProduto, ativo, estoquePositivo, servico, valor1, valor2);
        list.addAll(produtos2);
        return list;
    }

    @Transactional(readOnly=true)
    public List<ProdutoComposicao> listaProdutosCombo(Produto produto) {
        return this.produtoComposicaoRepository.lista(produto.getId());
    }

    @Transactional(readOnly=true)
    public List<RelatorioInventarioBean> relatorioInventario(CategoriaProduto categoriaProduto) {
        List produtos = this.produtoRepository.relatorioListaProduto(categoriaProduto, Boolean.TRUE, Boolean.valueOf(false), "");
        ArrayList<RelatorioInventarioBean> lista = new ArrayList<RelatorioInventarioBean>();
        produtos.stream().map(p -> {
            RelatorioInventarioBean bean = new RelatorioInventarioBean();
            bean.setCodigo(p.getCodigo());
            bean.setProduto(p.getNome().toUpperCase());
            bean.setUnidade(p.getUnidade().getSigla());
            bean.setEstoque(p.getEstoqueAtual());
            bean.setValorUnitario(p.getUltimoCusto());
            bean.setCustoTotal(bean.getEstoque().multiply(p.getUltimoCusto()));
            bean.setCategoria(p.getCategoriaProduto().getNome());
            return bean;
        }).forEachOrdered(bean -> lista.add((RelatorioInventarioBean)bean));
        return lista;
    }

    @Transactional(readOnly=true)
    public List<Produto> relatorioLista(CategoriaProduto categoriaProduto, Boolean estoqueMinimo, Boolean estoquePositivo, String descricao) {
        return this.produtoRepository.relatorioListaProduto(categoriaProduto, estoquePositivo, estoqueMinimo, descricao);
    }

    @Transactional(readOnly=true)
    public List<Produto> relatorioEstoqueBaixo(CategoriaProduto categoriaProduto) {
        return this.produtoRepository.relatorioEstoqueBaixo(categoriaProduto);
    }

    @Transactional(readOnly=true)
    public List<Produto> relatorioTabelaPreco(CategoriaProduto categoriaProduto, Boolean orderCodigo) {
        return this.produtoRepository.relatorioTabelaPreco(categoriaProduto, orderCodigo);
    }

    @Transactional(readOnly=true)
    public List<Produto> listaSped() {
        return this.produtoRepository.listaSped();
    }

    @Transactional(readOnly=true)
    public List<ProdutoInventarioBean> listaInventario(LocalDate dataEstoque) {
        List produtos = this.produtoRepository.pesquisa("%%", "");
        ArrayList<ProdutoInventarioBean> retorno = new ArrayList<ProdutoInventarioBean>();
        produtos.stream().map(p -> this.produtoExtratoRepository.inventario(dataEstoque, p)).filter(extrato -> extrato != null && extrato.getEstoqueAtual().compareTo(BigDecimal.ZERO) > 0).map(extrato -> {
            ProdutoInventarioBean bean = new ProdutoInventarioBean();
            bean.setCodigo("P" + extrato.getProduto().getId().toString());
            bean.setCusto(extrato.getProduto().getUltimoCusto());
            bean.setDescricao(extrato.getProduto().getNome());
            bean.setEstoque(extrato.getEstoqueAtual());
            bean.setTotalItem(bean.getCusto().multiply(bean.getEstoque()).setScale(2, RoundingMode.HALF_EVEN));
            bean.setUnidade(extrato.getProduto().getUnidade().getSigla());
            bean.setProduto(extrato.getProduto());
            return bean;
        }).forEachOrdered(bean -> retorno.add((ProdutoInventarioBean)bean));
        return retorno;
    }

    @Transactional(readOnly=true)
    public String geraCodigo() {
        Produto produto = this.produtoRepository.ultimoId();
        if (produto == null) {
            return "0001";
        }
        Long codigo = produto.getId() + 1L;
        int tamanho = 4;
        String codigoTxt = MaximaUtils.completaEsquerda((String)codigo.toString(), (String)"0", (int)tamanho);
        Boolean existeProduto = true;
        while (existeProduto.booleanValue()) {
            Produto produtoExiste = this.produtoRepository.getByCodigoBarras(codigoTxt);
            if (produtoExiste == null) {
                existeProduto = false;
                continue;
            }
            codigo = codigo + 1L;
            codigoTxt = MaximaUtils.completaEsquerda((String)codigo.toString(), (String)"0", (int)tamanho);
        }
        return codigoTxt;
    }

    @Transactional(readOnly=true)
    public List<Produto> lista(CategoriaProduto categoriaProduto, Boolean estoquePositivo) {
        return this.produtoRepository.lista(categoriaProduto, estoquePositivo);
    }

    @Transactional(readOnly=true)
    public List<Produto> listaBalanca() {
        return this.produtoRepository.listaBalanca();
    }

    @Transactional(readOnly=true)
    public List<Produto> listaTodos() {
        return this.produtoRepository.listaTodos();
    }

    @Transactional(readOnly=true)
    public List<ProdutoIngrediente> listaIngredientes(Produto produto) {
        if (produto == null || produto.getId() == null) {
            return new ArrayList<ProdutoIngrediente>();
        }
        return this.produtoIngredienteRepository.listaPorProduto(produto.getId());
    }

    @Transactional(readOnly=true)
    public Produto getById(long id) {
        Optional produto = this.produtoRepository.findById((Object)id);
        if (produto.isPresent()) {
            return (Produto)produto.get();
        }
        return null;
    }

    @Transactional(readOnly=true)
    public List<Produto> listaProdutosTamanhos(Produto produtoPai) {
        System.out.println("produtopai****" + produtoPai.getId());
        return this.produtoRepository.listaProdutosTamanhos(produtoPai.getId());
    }

    @Transactional(readOnly=true)
    public List<Produto> listaSincronizar() {
        return this.produtoRepository.sincronizar();
    }

    @Transactional(readOnly=true)
    public List<Produto> listaVendasExternas() {
        return this.produtoRepository.listaAplicativo();
    }

    public void salvaListaOrdenada(List<Produto> produtos) throws MaximaException {
        int count = 1;
        for (Produto produto : produtos) {
            System.out.println("== produto estoque: " + produto.getEstoqueAtual());
            produto = (Produto)this.produtoRepository.findById((Object)produto.getId()).get();
            System.out.println("== produto estoque: " + produto.getEstoqueAtual());
            produto.setOrdem(count);
            this.produtoRepository.save((Object)produto);
            ++count;
        }
    }

    @Transactional(readOnly=true)
    public List<Produto> getListaOrdenada() {
        return this.produtoRepository.listaOrdenado();
    }

    @Transactional(readOnly=true)
    public ProdutoFoto getFotoPrincipal(Long produtoId) {
        if (produtoId == null) {
            return null;
        }
        return this.produtoFotoRepository.getPrincipal(produtoId);
    }

    @Transactional(readOnly=true)
    public ProdutoFoto getFoto(Long produtoId) {
        if (produtoId == null) {
            return null;
        }
        return this.produtoFotoRepository.getFoto(produtoId);
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> listarVendas(Produto produto) {
        return this.vendaProdutoRepository.vendasPorProduto(produto.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<VendaProdutoItem> listarVendaItens(Produto produto) {
        return this.vendaProdutoItemRepository.vendasPorProduto(produto.getId().longValue());
    }

    public void atualizaEstoque(Produto produto, BigDecimal estoque) {
        produto = (Produto)this.produtoRepository.findById((Object)produto.getId()).get();
        BigDecimal estoqueAnterior = produto.getEstoqueAtual();
        produto.setEstoqueAtual(estoque);
        produto.setUltimaAlteracao(LocalDateTime.now());
        produto = (Produto)this.produtoRepository.save((Object)produto);
        ProdutoExtrato produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "ALTERA\u00c7\u00c3O DE ESTOQUE MANUAL", BigDecimal.ZERO, "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.BALANCO);
        this.produtoExtratoRepository.save((Object)produtoExtrato);
    }

    @Transactional(readOnly=true)
    public List<ProdutoExtratoDto> extratoProduto(Long produtoId) {
        List listaProdutoExtrato = this.produtoExtratoRepository.listaPorProduto(produtoId);
        ArrayList<ProdutoExtratoDto> retorno = new ArrayList<ProdutoExtratoDto>();
        for (ProdutoExtrato extrato : listaProdutoExtrato) {
            ProdutoExtratoDto dto = new ProdutoExtratoDto();
            dto.setDataEmissao(MaximaDate.getData((LocalDate)extrato.getDataMovimento()));
            dto.setCodigo(extrato.getProduto().getCodigo());
            dto.setProduto(extrato.getProduto().getNome().toUpperCase());
            dto.setOperacao(extrato.getTipoOperacao());
            dto.setEstoqueAtual(extrato.getEstoqueAtual());
            dto.setQuantidade(extrato.getQuantidade());
            dto.setEstoqueAnterior(extrato.getEstoqueAnterior());
            retorno.add(dto);
        }
        return retorno;
    }

    @Transactional(readOnly=true)
    public ProdutoMva getMva(Long produtoId, Estado estado) throws MaximaException {
        return (ProdutoMva)this.produtoMvaRepository.get(produtoId, estado.getId()).orElseThrow(() -> new MaximaException("Configura\u00e7\u00e3o de MVA/IVa n\u00e3o encontrada na tabela do banco de dados."));
    }

    @Transactional(readOnly=false)
    public void atualizaFornecedor() {
        List produtos = this.produtoRepository.findAll(Sort.by((String[])new String[]{"id"}));
        for (Produto produto : produtos) {
            List fornecedores = this.entradaProdutoItemRepository.listaFornecedorPorProduto(produto.getId());
            for (Fornecedor forn : fornecedores) {
                ProdutoFornecedor pf = new ProdutoFornecedor();
                pf.setProduto(produto);
                pf.setFornecedor(forn);
                this.produtoFornecedorRepository.save((Object)pf);
            }
        }
    }
}

