/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.repository.UnidadeRepository;
import br.com.maximasolutions.estoque.service.UnidadeService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class UnidadeServiceImpl
implements UnidadeService {
    @Autowired
    private UnidadeRepository unidadeRepository;

    @Transactional(readOnly=true)
    public List<Unidade> list() {
        return this.unidadeRepository.list();
    }

    @Transactional(readOnly=true)
    public Unidade load(long id) {
        Optional unidade = this.unidadeRepository.findById((Object)id);
        if (unidade.isPresent()) {
            return (Unidade)unidade.get();
        }
        return null;
    }

    public Unidade save(Unidade unidade) throws MaximaException {
        unidade.setSincronizado(Boolean.FALSE);
        unidade.setSincronizadoPDV(Boolean.FALSE);
        return (Unidade)this.unidadeRepository.save((Object)unidade);
    }

    public void deleteById(Long id) {
        Unidade unidade = (Unidade)this.unidadeRepository.findById((Object)id).get();
        unidade.setAtivo(Boolean.valueOf(false));
        this.unidadeRepository.save((Object)unidade);
    }

    @Transactional(readOnly=true)
    public List<Unidade> pesquisa(String valor) {
        if (valor != null && valor.equals("%")) {
            return this.unidadeRepository.pesquisa(valor);
        }
        return this.unidadeRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public Unidade getBySigla(String sigla) throws MaximaValidacaoException {
        List lista = this.unidadeRepository.getBySigla(sigla);
        if (lista.isEmpty()) {
            return null;
        }
        if (lista.size() > 1) {
            throw new MaximaValidacaoException("Existe mais de um tipo de unidade cadastrado com a mesma sigla: '" + sigla + "'");
        }
        return (Unidade)lista.get(0);
    }

    @Transactional(readOnly=true)
    public List<Unidade> listaTodas() {
        return this.unidadeRepository.listaTodas();
    }

    @Transactional(readOnly=true)
    public List<Unidade> listaSincronizar() {
        return this.unidadeRepository.sincronizar();
    }
}

