/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.delivery.modelo.Entregador;
import br.com.maximasolutions.estoque.bean.VendaProdutoItemBean;
import br.com.maximasolutions.estoque.bean.VendaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.bean.VendasCategoriasBean;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.TipoMovimentacao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioVendaProdutoPorDiaBean;
import br.com.maximasolutions.estoque.relatorio.dto.VendaProdutoGraficoDto;
import br.com.maximasolutions.financeiro.bean.MovimentoCaixaItemVendidoBean;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.modelo.ContaReceber;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

public interface VendaProdutoService {
    public VendaProduto getById(Long var1);

    public VendaProduto getByPedido(Long var1);

    public VendaProduto getUltima(Long var1);

    public VendaProduto getUltimaMovimentoCaixa(Long var1);

    public VendaProduto salva(Pedido var1, Cliente var2, TipoMovimentacao var3) throws MaximaException;

    public VendaProduto salva(Pedido var1, Cliente var2, TipoMovimentacao var3, Entregador var4) throws MaximaException;

    public VendaProduto fechamentoPDV(Pedido var1, Cliente var2, CondicaoRecebimento var3, BigDecimal var4, BigDecimal var5) throws MaximaException;

    public VendaProduto fechamentoPDV(Pedido var1, Cliente var2, List<VendaProdutoFaturamento> var3, BigDecimal var4) throws MaximaException;

    public VendaProduto fechamentoSemFaturamento(Pedido var1, Cliente var2) throws MaximaException;

    public VendaProduto faturamento(VendaProduto var1, List<VendaProdutoFaturamento> var2, BigDecimal var3) throws MaximaException;

    public VendaProduto agrupa(List<VendaProduto> var1) throws MaximaException;

    public VendaProduto delete(VendaProduto var1) throws MaximaException;

    public VendaProduto deleteFaturamento(VendaProduto var1, Boolean var2) throws MaximaException;

    public VendaProduto getByContaReceber(ContaReceber var1);

    public List<VendaProduto> lista(LocalDate var1, LocalDate var2, String var3);

    public List<VendaProduto> emAberto(LocalDate var1, LocalDate var2, String var3);

    public List<VendaProduto> faturadas(LocalDate var1, LocalDate var2, String var3);

    public List<VendaProduto> faturadas(LocalDate var1, LocalDate var2, Cliente var3);

    public List<Object[]> faturamentos(LocalDate var1, LocalDate var2, Vendedor var3);

    public List<VendaProduto> listaCondicional(String var1);

    public List<VendaProduto> listaEmEntrega(String var1);

    public List<VendaProduto> lista(LocalDate var1, LocalDate var2, Boolean var3, Boolean var4, String var5);

    public BigDecimal totalLista(LocalDate var1, LocalDate var2, Boolean var3, Boolean var4, String var5);

    public BigDecimal liquidoLista(LocalDate var1, LocalDate var2, Boolean var3, Boolean var4, String var5);

    public BigDecimal total(LocalDate var1, LocalDate var2, String var3);

    public List<VendaProduto> listaPorMovimentoCaixa(MovimentoCaixa var1);

    public List<VendaProduto> listaPorMovimentoCaixaSemFaturar(MovimentoCaixa var1);

    public List<VendaProdutoItem> listItens(VendaProduto var1);

    public List<ContaReceberParcela> listParcelas(VendaProduto var1);

    public List<VendaProdutoFaturamento> listaFaturamentos(VendaProduto var1);

    public BigDecimal totalPorPeriodo(LocalDate var1, LocalDate var2);

    public BigDecimal totalCondicaoPagamento(LocalDate var1, LocalDate var2, CondicaoRecebimento var3);

    public BigDecimal quantidadeCondicaoPagamento(LocalDate var1, LocalDate var2, CondicaoRecebimento var3);

    public List<VendaProduto> relatorio(LocalDate var1, LocalDate var2, Boolean var3, Cliente var4, Vendedor var5);

    public List<RelatorioVendaProdutoPorDiaBean> relatorio(LocalDate var1, LocalDate var2, Vendedor var3);

    public List<VendaProdutoGraficoDto> grafico(LocalDate var1, LocalDate var2, Boolean var3, Cliente var4);

    public List<VendaProdutoItemBean> relatorioProdutos(LocalDate var1, LocalDate var2, Boolean var3, Cliente var4, Vendedor var5, CategoriaProduto var6, Boolean var7, VendaProdutoItemOrderBy var8);

    public List<VendaProdutoItemBean> relatorioProdutosAgrupados(LocalDate var1, LocalDate var2, Boolean var3, Vendedor var4);

    public List<VendaProdutoItemBean> relatorioProdutosAgrupadosCliente(LocalDate var1, LocalDate var2, Boolean var3, Cliente var4);

    public void imprimeUltimaVenda() throws MaximaException;

    public void imprimeVenda(VendaProduto var1) throws MaximaException;

    public void imprimeOS(VendaProduto var1) throws MaximaException;

    public List<VendasCategoriasBean> vendasCategorias(LocalDate var1, LocalDate var2);

    public List<MovimentoCaixaItemVendidoBean> listaProdutosPorMovimentoCaixa(MovimentoCaixa var1);

    public VendaProduto listaPdvToErp();

    public void testeFaturamento();
}

