/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.utils;

import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.ProdutoComposicao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoCombo;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.modelo.ContaReceber;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class VendaProdutoUtils {
    public MovimentacaoEntrada createMovimentacaoEntrada(ContaReceberParcela crp, MovimentoCaixa movimentoCaixa) {
        MovimentacaoEntrada rec = new MovimentacaoEntrada();
        rec.setCliente(crp.getCliente());
        rec.setCondicaoPagamento(crp.getCondicaoPagamento());
        rec.setContaReceberParcela(crp);
        rec.setDataEmissao(crp.getDataEmissao());
        rec.setSaldoConta(BigDecimal.ZERO);
        rec.setDataMovimento(crp.getDataVencimento());
        rec.setDataOperacao(LocalDateTime.now());
        rec.setDesconto(BigDecimal.ZERO);
        rec.setEstornada(Boolean.FALSE);
        rec.setFormaPagamento(rec.getCondicaoPagamento().getFormaPagamento());
        rec.setHistorico(crp.getHistorico());
        rec.setJuros(BigDecimal.ZERO);
        rec.setMovimentoCaixa(movimentoCaixa);
        rec.setTotal(crp.getValor());
        rec.setValor(crp.getValor());
        rec.setValorLiquido(crp.getValorLiquido());
        return rec;
    }

    public VendaProdutoCombo createVendaProdutoCombo(VendaProdutoCombo vendaProdutoCombo, PedidoItem item, VendaProduto vendaProduto) {
        if (vendaProdutoCombo == null) {
            vendaProdutoCombo = new VendaProdutoCombo();
        }
        vendaProdutoCombo.setDataMovimento(LocalDateTime.now());
        vendaProdutoCombo.setDesconto(item.getDesconto());
        vendaProdutoCombo.setDescricao(item.getDescricao());
        vendaProdutoCombo.setObservacao(item.getObservacao());
        if (item.getProduto().getServico().booleanValue()) {
            vendaProdutoCombo.setServicoCusto(item.getServicoCusto());
            vendaProdutoCombo.setPrecoCusto(BigDecimal.ZERO);
        } else {
            vendaProdutoCombo.setPrecoCusto(item.getPrecoCusto());
            vendaProdutoCombo.setServicoCusto(BigDecimal.ZERO);
        }
        vendaProdutoCombo.setPrecoTotal(item.getPrecoTotal());
        vendaProdutoCombo.setPrecoUnitario(item.getPrecoUnitario());
        vendaProdutoCombo.setProduto(item.getProduto());
        vendaProdutoCombo.setQuantidade(item.getQuantidade());
        vendaProdutoCombo.setUnidade(item.getUnidade());
        vendaProdutoCombo.setVendaProduto(vendaProduto);
        vendaProdutoCombo.setVendedor(item.getVendedor());
        return vendaProdutoCombo;
    }

    public VendaProdutoItem createVendaProdutoItemCombo(VendaProdutoItem vendaProdutoItem, PedidoItem item, VendaProduto vendaProduto, ProdutoComposicao produtoComposicao) {
        if (vendaProdutoItem == null) {
            vendaProdutoItem = new VendaProdutoItem();
        }
        vendaProdutoItem.setAtivo(Boolean.TRUE);
        vendaProdutoItem.setDataMovimento(LocalDateTime.now());
        vendaProdutoItem.setDesconto(item.getDesconto());
        vendaProdutoItem.setDescricao(produtoComposicao.getSubProduto().getNome() + " (COMBO)");
        vendaProdutoItem.setNumItem(item.getNumItem());
        vendaProdutoItem.setObservacao(item.getObservacao());
        if (produtoComposicao.getSubProduto().getServico().booleanValue()) {
            vendaProdutoItem.setServicoCusto(produtoComposicao.getPrecoCusto());
            vendaProdutoItem.setPrecoCusto(BigDecimal.ZERO);
        } else {
            vendaProdutoItem.setPrecoCusto(produtoComposicao.getPrecoCusto());
            vendaProdutoItem.setServicoCusto(BigDecimal.ZERO);
        }
        vendaProdutoItem.setPrecoTotal(produtoComposicao.getValorTotal().multiply(item.getQuantidade()));
        vendaProdutoItem.setPrecoUnitario(produtoComposicao.getValorUnitario());
        vendaProdutoItem.setProduto(produtoComposicao.getSubProduto());
        vendaProdutoItem.setQuantidade(produtoComposicao.getQuantidade().multiply(item.getQuantidade()));
        vendaProdutoItem.setUnidade(produtoComposicao.getUnidade().getSigla());
        vendaProdutoItem.setVendaProduto(vendaProduto);
        vendaProdutoItem.setPedidoItem(item);
        vendaProdutoItem.setBrinde(item.getBrinde());
        vendaProdutoItem.setVendedor(item.getVendedor());
        return vendaProdutoItem;
    }

    public VendaProdutoItem createVendaProdutoItem(VendaProdutoItem vendaProdutoItem, PedidoItem item, VendaProduto vendaProduto) {
        if (vendaProdutoItem == null) {
            vendaProdutoItem = new VendaProdutoItem();
        }
        vendaProdutoItem.setAtivo(Boolean.TRUE);
        vendaProdutoItem.setDataMovimento(LocalDateTime.now());
        vendaProdutoItem.setDesconto(item.getDesconto());
        vendaProdutoItem.setFrete(item.getFrete());
        vendaProdutoItem.setDescricao(item.getDescricao());
        vendaProdutoItem.setNumItem(item.getNumItem());
        vendaProdutoItem.setObservacao(item.getObservacao());
        if (item.getProduto().getServico().booleanValue()) {
            vendaProdutoItem.setServicoCusto(item.getServicoCusto());
            vendaProdutoItem.setPrecoCusto(BigDecimal.ZERO);
        } else {
            vendaProdutoItem.setPrecoCusto(item.getPrecoCusto());
            vendaProdutoItem.setServicoCusto(BigDecimal.ZERO);
        }
        vendaProdutoItem.setPrecoTotal(item.getPrecoTotal());
        vendaProdutoItem.setPrecoUnitario(item.getPrecoUnitario());
        vendaProdutoItem.setProduto(item.getProduto());
        vendaProdutoItem.setQuantidade(item.getQuantidade());
        vendaProdutoItem.setUnidade(item.getUnidade());
        vendaProdutoItem.setVendaProduto(vendaProduto);
        vendaProdutoItem.setPedidoItem(item);
        vendaProdutoItem.setVendedor(item.getVendedor());
        vendaProdutoItem.setBrinde(item.getBrinde());
        return vendaProdutoItem;
    }

    public VendaProduto createVendaProduto(VendaProduto venda, Pedido pedido, MovimentoCaixa movimentoCaixa) {
        if (venda == null || venda.getId() == null) {
            venda = new VendaProduto();
            venda.setDataEmissao(LocalDate.now());
            venda.setHora(MaximaDate.getHoraAtual());
        }
        venda.setAcrescimo(pedido.getAcrescimo());
        venda.setAtivo(Boolean.TRUE);
        venda.setCliente(pedido.getCliente());
        venda.setDataOperacao(LocalDateTime.now());
        venda.setDesconto(pedido.getDesconto());
        venda.setExcluida(Boolean.FALSE);
        venda.setFaturado(Boolean.FALSE);
        venda.setFinalizada(Boolean.TRUE);
        venda.setMovimentoCaixa(movimentoCaixa);
        venda.setObservacao(pedido.getObservacao());
        venda.setPedido(pedido);
        venda.setTotal(pedido.getTotal());
        venda.setValorFrete(pedido.getFrete());
        venda.setValorProdutos(pedido.getValorProdutos());
        venda.setValorServico(pedido.getValorServico());
        venda.setValorPecas(pedido.getValorPecas());
        venda.setVendedor(pedido.getVendedor());
        venda.setCustoProdutos(pedido.getCustoProdutos());
        venda.setCustoServicos(pedido.getCustoServicos());
        venda.setCustoTotal(pedido.getCustoTotal());
        venda.setValorDevolucao(pedido.getValorDevolucao());
        venda.setDevolucao(pedido.getDevolucao());
        return venda;
    }

    public List<ContaReceberParcela> createContaReceberParcela(ContaReceber contaReceber, List<VendaProdutoFaturamento> faturamentos, BigDecimal troco) {
        ArrayList<ContaReceberParcela> parcelas = new ArrayList<ContaReceberParcela>();
        for (VendaProdutoFaturamento fat : faturamentos) {
            CondicaoRecebimento condicaoRecebimento = fat.getCondicaoRecebimento();
            LocalDate hoje = LocalDate.now();
            BigDecimal valorParcela = fat.getValorRecebimento().divide(new BigDecimal(condicaoRecebimento.getParcelas()), 2, RoundingMode.HALF_EVEN);
            for (int numParcela = 1; numParcela <= condicaoRecebimento.getParcelas(); ++numParcela) {
                ContaReceberParcela parcela = new ContaReceberParcela();
                parcela.setCliente(contaReceber.getCliente());
                parcela.setCentroCusto(contaReceber.getCentroCusto());
                parcela.setCondicaoPagamento(fat.getCondicaoRecebimento());
                parcela.setContaReceber(contaReceber);
                parcela.setDataOperacao(LocalDateTime.now());
                parcela.setDataEmissao(LocalDateTime.now());
                LocalDate vencimento = condicaoRecebimento.getFixarDia() != false ? hoje.plusMonths(numParcela) : hoje.plusDays(condicaoRecebimento.getDiasParaEntrada() + (numParcela - 1) * condicaoRecebimento.getIntervaloEntreParcelas());
                parcela.setDataVencimento(vencimento);
                parcela.setExcluido(Boolean.FALSE);
                parcela.setFormaPagamento(condicaoRecebimento.getFormaPagamento());
                parcela.setHistorico(contaReceber.getHistorico());
                parcela.setNumeroParcela(String.valueOf(numParcela) + "/" + condicaoRecebimento.getParcelas());
                BigDecimal valorContaReceber = valorParcela;
                if (numParcela == 1) {
                    BigDecimal diferenca = MaximaNumber.diferencaSomatoriaParcleas((BigDecimal)fat.getValorRecebimento(), (BigDecimal)new BigDecimal(condicaoRecebimento.getParcelas()));
                    System.out.println("== Diferenca: " + diferenca);
                    valorContaReceber = valorParcela.add(diferenca);
                }
                if (condicaoRecebimento.getTaxaRecebimentoPercentual().compareTo(BigDecimal.ZERO) > 0) {
                    valorContaReceber = valorParcela.subtract(valorParcela.multiply(condicaoRecebimento.getTaxaRecebimentoPercentual()));
                }
                parcela.setValor(valorContaReceber);
                parcela.setValorLiquido(valorContaReceber);
                parcela.setValorOriginal(fat.getValorRecebimento());
                if (condicaoRecebimento.getRecebido().booleanValue()) {
                    parcela.setQuitado(true);
                    parcela.setValorPendente(BigDecimal.ZERO);
                    parcela.setDataPagamento(vencimento);
                } else {
                    parcela.setQuitado(false);
                    parcela.setValorPendente(valorContaReceber);
                }
                parcelas.add(parcela);
            }
        }
        return parcelas;
    }

    public ContaReceber createContaReceber(VendaProduto vendaProduto, CentroCusto centroCusto) {
        ContaReceber contaReceber = new ContaReceber();
        contaReceber.setCentroCusto(centroCusto);
        contaReceber.setCliente(vendaProduto.getCliente());
        contaReceber.setDataDocumento(vendaProduto.getDataEmissao());
        contaReceber.setHistorico("VENDA [ " + vendaProduto.getId() + " ]");
        contaReceber.setNumeroNota(vendaProduto.getId().toString());
        return contaReceber;
    }
}

