/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.boleto;

import br.com.maximasolutions.financeiro.boleto.bean.BoletoRetorno;
import br.com.maximasolutions.financeiro.boleto.bean.BoletoRetornoDetalhe;
import br.com.maximasolutions.financeiro.boleto.bean.BoletoRetornoHeader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class SantanderRetorno {
    private final File arquivoRetorno;
    private final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("ddMMyyyy");

    public SantanderRetorno(File arquivo) {
        this.arquivoRetorno = arquivo;
    }

    public BoletoRetorno getRetorno() throws IOException {
        List texto = this.leArquivo();
        return this.getCNAB240Retorno(texto);
    }

    private BoletoRetorno getCNAB240Retorno(List<String> texto) {
        BoletoRetorno retorno = new BoletoRetorno();
        retorno.setHeader(this.getHeader(texto.get(0)));
        retorno.setRecebimentos(this.getRecebimentos(texto));
        return retorno;
    }

    private BoletoRetornoHeader getHeader(String linha) {
        BoletoRetornoHeader header = new BoletoRetornoHeader();
        header.setBanco(linha.substring(0, 3));
        header.setCnpj(linha.substring(18, 32));
        header.setConvenio(linha.substring(52, 61));
        header.setDataArquivo(LocalDate.parse(linha.substring(143, 151), this.FORMATTER));
        return header;
    }

    private List<BoletoRetornoDetalhe> getRecebimentos(List<String> texto) {
        ArrayList<BoletoRetornoDetalhe> recebimentos = new ArrayList<BoletoRetornoDetalhe>();
        int numeroLinha = 2;
        while (numeroLinha < texto.size() - 2) {
            String linhaU;
            String linhaT = texto.get(numeroLinha);
            String segmento = linhaT.substring(13, 14);
            String codigoMovimento = linhaT.substring(15, 17);
            if (!codigoMovimento.equalsIgnoreCase("06")) {
                numeroLinha += 2;
                continue;
            }
            BoletoRetornoDetalhe detalhe = new BoletoRetornoDetalhe();
            if (segmento.equals("T")) {
                detalhe.setNumeroDocumento(linhaT.substring(54, 60));
                detalhe.setDataVencimento(LocalDate.parse(linhaT.substring(69, 77), this.FORMATTER));
                detalhe.setValor(this.formataNumero(linhaT.substring(77, 92)));
            }
            if ((segmento = (linhaU = texto.get(numeroLinha + 1)).substring(13, 14)).equals("U")) {
                detalhe.setJuros(this.formataNumero(linhaU.substring(17, 32)));
                detalhe.setDesconto(this.formataNumero(linhaU.substring(32, 47)));
                detalhe.setTotal(this.formataNumero(linhaU.substring(77, 92)));
                detalhe.setDataRecebimento(LocalDate.parse(linhaU.substring(137, 145), this.FORMATTER));
            }
            recebimentos.add(detalhe);
            numeroLinha += 2;
        }
        return recebimentos;
    }

    private List<String> leArquivo() throws IOException {
        String linha;
        FileInputStream fis = new FileInputStream(this.arquivoRetorno);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<String> retorno = new ArrayList<String>();
        while ((linha = br.readLine()) != null) {
            retorno.add(linha);
        }
        return retorno;
    }

    private BigDecimal formataNumero(String valor) {
        if (valor == null || valor.isEmpty()) {
            return null;
        }
        if (valor.length() <= 2) {
            return new BigDecimal("0." + valor);
        }
        String decimal = valor.substring(valor.length() - 2, valor.length());
        String numero = valor.substring(0, valor.length() - 2);
        return new BigDecimal(numero + "." + decimal);
    }
}

