/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.controller.BancoBoletoFormController;
import br.com.maximasolutions.financeiro.modelo.BancoBoleto;
import br.com.maximasolutions.financeiro.service.BancoBoletoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class BancoBoletoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<BancoBoleto> tabela;
    @FXML
    private TableColumn<BancoBoleto, String> colBanco;
    @FXML
    private TableColumn<BancoBoleto, String> colConta;
    @Autowired
    private BancoBoletoService bancoBoletoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<BancoBoleto> bancoBoletoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.bancoBoletoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaBancoBoleto();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.BancoBoleto);
    }

    private void novoBancoBoleto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formBancoBoleto(null);
        this.loadTabela();
    }

    private void editaBancoBoleto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        BancoBoleto bancoBoleto = (BancoBoleto)this.tabela.getSelectionModel().getSelectedItem();
        if (bancoBoleto == null) {
            MaximaAlert.alerta((String)"Selecione um banco boleto para editar.");
            return;
        }
        this.formBancoBoleto(bancoBoleto);
        this.loadTabela();
    }

    private void formBancoBoleto(BancoBoleto bancoBoleto) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/bancoBoleto/BancoBoletoForm.fxml", "Edita Banco Boleto");
            BancoBoletoFormController controller = (BancoBoletoFormController)stage.getUserData();
            controller.inicializa(bancoBoleto);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(BancoBoletoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form banco boleto.\n" + ex.getMessage()));
        }
    }

    private void deleteBancoBoleto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        BancoBoleto bancoBoleto = (BancoBoleto)this.tabela.getSelectionModel().getSelectedItem();
        if (bancoBoleto == null) {
            MaximaAlert.alerta((String)"Selecione um banco boleto para remover.");
            return;
        }
        if (MaximaAlert.confirmacao((String)("Deseja remover o banco boleto: '" + bancoBoleto.getBancoTipo() + "'?"))) {
            this.bancoBoletoService.deleteById(bancoBoleto.getId());
            MaximaAlert.confirmacao((String)"Banco boleto deletado com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.bancoBoletoList.clear();
        List list = this.bancoBoletoService.list();
        this.bancoBoletoList.addAll((Collection)list);
        this.tabela.setItems(this.bancoBoletoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colBanco.setCellValueFactory((Callback)new PropertyValueFactory("bancoTipo"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoBancoBoleto());
        this.btnEdita.setOnAction(event -> this.editaBancoBoleto());
        this.btnDelete.setOnAction(event -> this.deleteBancoBoleto());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

