/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.boleto.SantanderRetorno;
import br.com.maximasolutions.financeiro.boleto.bean.BoletoRetorno;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.financeiro.service.MovimentacaoEntradaService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class BoletoBaixaFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private TextField tfArquivo;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnArquivo;
    @FXML
    private TableView<ContaReceberParcela> tabela;
    @FXML
    private TableColumn<ContaReceberParcela, String> colCliente;
    @FXML
    private TableColumn<ContaReceberParcela, String> colCodigo;
    @FXML
    private TableColumn<ContaReceberParcela, String> colObservacao;
    @FXML
    private TableColumn<ContaReceberParcela, String> colData;
    @FXML
    private TableColumn<ContaReceberParcela, String> colFormaPagamento;
    @FXML
    private TableColumn<ContaReceberParcela, BigDecimal> colTotal;
    @FXML
    private TableColumn<ContaReceberParcela, BigDecimal> colTotalPendente;
    @FXML
    private Label lblTotal;
    @Autowired
    private MovimentacaoEntradaService movimentacaoEntradaService;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    private ObservableList<ContaReceberParcela> contaReceberParcelaList;
    private List<ContaReceberParcela> parcelas;

    public void initialize(URL url, ResourceBundle rb) {
        this.contaReceberParcelaList = FXCollections.observableArrayList();
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
        this.setColumnProperties();
    }

    private void save() {
        if (this.parcelas == null || this.parcelas.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhuma parcela carregada para recebimento.");
            return;
        }
        try {
            this.movimentacaoEntradaService.recebimentoEmLote(this.parcelas);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Recebimentos efetuados com sucesso.");
            this.tfArquivo.setText("");
            this.parcelas = new ArrayList();
            this.loadTabela();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(BoletoBaixaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private void abreArquivo() {
        BoletoRetorno retorno;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Arquivo de retorno", new String[]{".txt"}));
        File arquivoTxt = fileChooser.showOpenDialog(this.btnSalva.getScene().getWindow());
        if (arquivoTxt == null) {
            return;
        }
        this.tfArquivo.setText(arquivoTxt.getName());
        SantanderRetorno santanderRetorno = new SantanderRetorno(arquivoTxt);
        try {
            retorno = santanderRetorno.getRetorno();
        }
        catch (IOException ex) {
            Logger.getLogger(BoletoBaixaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel ler o arquivo de retorno.\n" + ex.getMessage()));
            return;
        }
        try {
            this.parcelas = this.contaReceberParcelaService.parcelasEmLote(retorno.getRecebimentos());
            this.loadTabela();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(BoletoBaixaFormController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
        this.btnArquivo.setOnAction(event -> this.abreArquivo());
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteParcela();
            }
        });
    }

    private void deleteParcela() {
        ContaReceberParcela selecionada = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (selecionada == null) {
            return;
        }
        int cont = 0;
        for (ContaReceberParcela parc : this.parcelas) {
            if (selecionada.getId().equals(parc.getId())) {
                this.parcelas.remove(cont);
                break;
            }
            ++cont;
        }
        this.loadTabela();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnArquivo.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void loadCombos() {
    }

    private void setMascaras() {
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataVencimento"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colFormaPagamento.setCellValueFactory((Callback)new PropertyValueFactory("formaPagamento"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("valorPendente"));
        this.colTotalPendente.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalPendente.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
        this.tabela.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    private void loadTabela() {
        this.contaReceberParcelaList.clear();
        this.contaReceberParcelaList.addAll((Collection)this.parcelas);
        this.tabela.setItems(this.contaReceberParcelaList);
        BigDecimal valorRecebido = BigDecimal.ZERO;
        for (ContaReceberParcela parc : this.parcelas) {
            valorRecebido = valorRecebido.add(parc.getTotal());
        }
        this.lblTotal.setText("VALOR RECEBIDO: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)valorRecebido, (int)2));
    }
}

