/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.Datas;
import br.com.caelum.stella.boleto.Endereco;
import br.com.caelum.stella.boleto.Pagador;
import br.com.caelum.stella.boleto.bancos.Santander;
import br.com.caelum.stella.boleto.transformer.GeradorDeBoleto;
import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.boleto.BopepoGerandoVariosBoletosEmUmPDF;
import br.com.maximasolutions.financeiro.modelo.BoletoEmitido;
import br.com.maximasolutions.financeiro.service.BancoBoletoService;
import br.com.maximasolutions.financeiro.service.BoletoEmitidoService;
import br.com.maximasolutions.financeiro.service.BoletoTecnospeedService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.geral.modelo.Empresa;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class BoletoEmitidoController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnImprime;
    @FXML
    private Button btnDelete;
    @FXML
    private TableView<BoletoEmitido> tabela;
    @FXML
    private TableColumn<BoletoEmitido, String> colCliente;
    @FXML
    private TableColumn<BoletoEmitido, String> colCodigo;
    @FXML
    private TableColumn<BoletoEmitido, String> colData;
    @FXML
    private TableColumn<BoletoEmitido, BigDecimal> colTotal;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private BoletoEmitidoService boletoEmitidoService;
    @Autowired
    private BoletoTecnospeedService tecnospeedService;
    @Autowired
    private BancoBoletoService bancoBoletoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<BoletoEmitido> boletoEmitidoList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.boletoEmitidoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.carregaIcones();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.BancoBoleto);
    }

    private void deleteBoleto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        ObservableList boletos = this.tabela.getSelectionModel().getSelectedItems();
        if (boletos == null || boletos.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione ao menos um boleto para excluir.");
            return;
        }
        try {
            this.boletoEmitidoService.delete((List)boletos);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Boleto(s) exclu\u00eddo(s) com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(BoletoEmitidoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel excluir os boletos.\n" + ex.getMessage()));
        }
    }

    private void imprimeBoleto() {
        ObservableList boletos = this.tabela.getSelectionModel().getSelectedItems();
        if (boletos == null || boletos.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione ao menos um boleto para imprimir.");
            return;
        }
        if (MaximaConfig.getBoletoCarne().booleanValue()) {
            try {
                new BopepoGerandoVariosBoletosEmUmPDF().gerarPdfCarne((List)boletos);
            }
            catch (IOException ex) {
                Logger.getLogger(BoletoEmitidoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Erro ao gerar pdf dos boletos.\n" + ex.getMessage()));
            }
        } else {
            boletos.forEach(boleto -> this.imprimeUmPorFolha(boleto));
        }
        MaximaAlert.informe((StageManager)this.stageManager, (String)"Boletos gerados com sucesso.");
    }

    private void imprimeUmPorFolha(BoletoEmitido boleto) {
        Datas datas = Datas.novasDatas().comDocumento(boleto.getDataEmissao().getDayOfMonth(), boleto.getDataEmissao().getMonthValue(), boleto.getDataEmissao().getYear()).comProcessamento(boleto.getDataEmissao().getDayOfMonth(), boleto.getDataEmissao().getMonthValue(), boleto.getDataEmissao().getYear()).comVencimento(boleto.getDataVencimento().getDayOfMonth(), boleto.getDataVencimento().getMonthValue(), boleto.getDataVencimento().getYear());
        Empresa empresa = this.conf.getEmpresaNFe();
        Endereco enderecoBeneficiario = Endereco.novoEndereco().comLogradouro(empresa.getEndereco() + ", " + empresa.getNumero()).comBairro(empresa.getBairro()).comCep(empresa.getCep()).comCidade(empresa.getMunicipio().getNome()).comUf(empresa.getMunicipio().getEstado().getSigla());
        Beneficiario beneficiario = Beneficiario.novoBeneficiario().comNomeBeneficiario(empresa.getNome()).comAgencia(boleto.getAgencia()).comDigitoAgencia(boleto.getAgenciaDigito()).comCodigoBeneficiario(boleto.getNumeroConvenio()).comDigitoCodigoBeneficiario(null).comNumeroConvenio(boleto.getNumeroConvenio()).comCarteira("101").comEndereco(enderecoBeneficiario).comNossoNumero(boleto.getNossoNumero()).comDigitoNossoNumero(boleto.getNossoNumeroDigito()).comDocumento(empresa.getCpf());
        System.out.println("*** NOSSO NUMERO: " + boleto.getNossoNumero());
        Endereco enderecoPagador = Endereco.novoEndereco().comLogradouro(boleto.getClienteEndereco() + ", " + boleto.getClienteNumero()).comBairro(boleto.getClienteBairro()).comCep(boleto.getClienteCep()).comCidade(boleto.getClienteMunicipio()).comUf(boleto.getClienteUF());
        Pagador pagador = Pagador.novoPagador().comNome(boleto.getClienteNome()).comDocumento(boleto.getClienteCnpj()).comEndereco(enderecoPagador);
        Santander banco = new Santander();
        Boleto boletoGerado = Boleto.novoBoleto().comBanco((Banco)banco).comDatas(datas).comBeneficiario(beneficiario).comPagador(pagador).comValorBoleto(boleto.getValor().toString()).comNumeroDoDocumento(boleto.getNumeroDocumento()).comInstrucoes(new String[]{"Ap\u00f3s o vencimento cobrar multa de 2% e juros de 1% ao m\u00eas.", "N\u00e3o receber ap\u00f3s 5 dias."}).comLocaisDePagamento(new String[]{""});
        GeradorDeBoleto gerador = new GeradorDeBoleto(new Boleto[]{boletoGerado});
        gerador.geraPDF("C:/Maxima/" + boleto.getNumeroDocumento() + "-" + boleto.getDataVencimento().format(DateTimeFormatter.ofPattern("dd-MM-yyyy")) + "-Boleto-Mensalidade-Maxima.pdf");
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataVencimento"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
        this.tabela.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    private void loadTabela() {
        this.boletoEmitidoList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.boletoEmitidoService.lista(inicio, fim, filtro);
        this.boletoEmitidoList.addAll((Collection)list);
        this.tabela.setItems(this.boletoEmitidoList);
        this.lblTotal.setText("VALOR TOTAL: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)this.boletoEmitidoService.total(inicio, fim, filtro), (int)2));
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnImprime.setOnAction(event -> this.imprimeBoleto());
        this.btnDelete.setOnAction(event -> this.deleteBoleto());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

