/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CentroCustoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private TextField tfId;
    @FXML
    private Button btnSalva;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfDescricao;
    @FXML
    private CheckBox ccbAtivo;
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private CentroCustoService centroCustoService;
    private CentroCusto centroCusto;

    public void initialize(URL url, ResourceBundle rb) {
        this.centroCusto = null;
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
    }

    private void salva() {
        if (this.centroCusto == null) {
            this.centroCusto = new CentroCusto();
        }
        this.centroCusto.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.centroCusto.setDescricao(MaximaUtils.getText((String)this.tfDescricao.getText()));
        this.centroCusto.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        this.centroCusto.setUltimaAlteracao(LocalDateTime.now());
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.centroCusto, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.alerta((String)mensagemError);
            return;
        }
        try {
            this.centroCustoService.save(this.centroCusto);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Centro de custo salvo com sucesso.");
            Stage stage = (Stage)this.tfId.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(CentroCustoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel salvar o centro de custo.");
        }
    }

    public void inicializa(CentroCusto centroCusto1) {
        this.centroCusto = centroCusto1;
        if (this.centroCusto != null) {
            this.tfId.setText(this.centroCusto.getId().toString());
            this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.centroCusto.getUltimaAlteracao()));
            this.ccbAtivo.setSelected(this.centroCusto.getAtivo().booleanValue());
            this.tfNome.setText(this.centroCusto.getNome());
            this.tfDescricao.setText(this.centroCusto.getDescricao());
            this.tfNome.requestFocus();
            this.tfNome.selectAll();
        }
    }

    private void loadCombos() {
    }

    private void loadMascaras() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

