/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.controller.ContaPagarEditaFormController;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.financeiro.controller.ContaReceberController;
import br.com.maximasolutions.financeiro.controller.PagamentoFormController;
import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.service.ContaPagarParcelaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ContaPagarController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnPagamento;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnAddContaPagar;
    @FXML
    private Button btnRemove;
    @FXML
    private TableView<ContaPagarParcela> tabela;
    @FXML
    private TableColumn<ContaPagarParcela, String> colFornecedor;
    @FXML
    private TableColumn<ContaPagarParcela, String> colCodigo;
    @FXML
    private TableColumn<ContaPagarParcela, String> colObservacao;
    @FXML
    private TableColumn<ContaPagarParcela, String> colData;
    @FXML
    private TableColumn<ContaPagarParcela, String> colFormaPagamento;
    @FXML
    private TableColumn<ContaPagarParcela, BigDecimal> colTotal;
    @FXML
    private TableColumn<ContaPagarParcela, BigDecimal> colTotalPendente;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ContaPagarParcelaService contaPagarParcelaService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    private ObservableList<ContaPagarParcela> contaPagarParcelaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.contaPagarParcelaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.ContaPagar);
    }

    private void novoContaPagar() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        try {
            Stage formContaPagar = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaPagar/ContaPagarForm.fxml", "Cadastro de Contas a Pagar");
            ContaPagarFormController controller = (ContaPagarFormController)formContaPagar.getUserData();
            controller.inicializa(null);
            formContaPagar.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ContaPagarForm'.\n");
        }
    }

    private void editaContaPagar() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        ContaPagarParcela contaPagarParcela = (ContaPagarParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaPagarParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para editar os dados.");
            return;
        }
        if ((contaPagarParcela = this.contaPagarParcelaService.load(contaPagarParcela.getId())).existePagamento().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Parcela com pagamento efetuado. N\u00e3o pode ser alterada.");
            return;
        }
        try {
            Stage formContaPagar = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaPagar/ContaPagarEditaForm.fxml", "Edi\u00e7\u00e3o de Contas a Pagar");
            ContaPagarEditaFormController controller = (ContaPagarEditaFormController)formContaPagar.getUserData();
            controller.inicializa(contaPagarParcela);
            formContaPagar.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ContaPagarEditaForm'.\n");
        }
    }

    private void efetuaPagamento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.PAGAMENTO).booleanValue()) {
            return;
        }
        ContaPagarParcela contaPagarParcela = (ContaPagarParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaPagarParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para efetuar pagamento.");
            return;
        }
        contaPagarParcela = this.contaPagarParcelaService.load(contaPagarParcela.getId());
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaPagar/PagamentoForm.fxml", "Pagamento");
            PagamentoFormController controller = (PagamentoFormController)stage.getUserData();
            controller.inicializa(contaPagarParcela);
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaReceberController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de pagamento.\n" + ex.getMessage()));
        }
    }

    private void removeParcela() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        ContaPagarParcela contaPagarParcela = (ContaPagarParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaPagarParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para remover.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja remover a parcela selecionada?")) {
            return;
        }
        try {
            this.contaPagarParcelaService.remove(contaPagarParcela);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Parcela removida com sucesso.");
            this.loadTabela();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(ContaPagarController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataVencimento"));
        this.colFornecedor.setCellValueFactory((Callback)new PropertyValueFactory("fornecedor"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colFormaPagamento.setCellValueFactory((Callback)new PropertyValueFactory("formaPagamento"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colTotalPendente.setCellValueFactory((Callback)new PropertyValueFactory("valorPendente"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalPendente.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.contaPagarParcelaList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.contaPagarParcelaService.lista(inicio, fim, filtro, (FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        this.contaPagarParcelaList.addAll((Collection)list);
        this.tabela.setItems(this.contaPagarParcelaList);
        BigDecimal total = BigDecimal.ZERO;
        for (ContaPagarParcela parcela : list) {
            total = total.add(parcela.getValorPendente());
        }
        this.lblTotal.setText("VALOR TOTAL: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
    }

    private void carregaIcones() {
        this.btnAddContaPagar.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnPagamento.setGraphic((Node)new MaximaIcone().getIconeMoney());
        this.btnRemove.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void registraAcoes() {
        this.btnAddContaPagar.setOnAction(event -> this.novoContaPagar());
        this.btnEdita.setOnAction(event -> this.editaContaPagar());
        this.btnPagamento.setOnAction(event -> this.efetuaPagamento());
        this.btnRemove.setOnAction(event -> this.removeParcela());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }

    private void carregaCombos() {
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }
}

