/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.financeiro.service.ContaPagarParcelaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.geral.controller.FornecedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ContaPagarFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfFornecedorCodigo;
    @FXML
    private TextField tfFornecedorDescricao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfIntervalo;
    @FXML
    private TextField tfValor;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private DatePicker tfDataLancamento;
    @FXML
    private DatePicker tfDataVencimento;
    @FXML
    private ComboBox<CentroCusto> cbbCentroCusto;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private TableView<ContaPagarParcela> tabela;
    @FXML
    private TableColumn<ContaPagarParcela, String> colVencimento;
    @FXML
    private TableColumn<ContaPagarParcela, String> colHistorico;
    @FXML
    private TableColumn<ContaPagarParcela, BigDecimal> colValor;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFornecedor;
    @FXML
    private Button btnAddParcela;
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private ContaPagarParcelaService contaPagarParcelaService;
    @Autowired
    private CentroCustoService centroCustoService;
    private Fornecedor fornecedor;
    private List<ContaPagarParcela> parcelas;
    private ObservableList<ContaPagarParcela> contaPagarParcelaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
        this.setColumnProperties();
    }

    public void inicializa(ContaPagarParcela cpp) {
        this.fornecedor = null;
        this.parcelas = null;
        this.contaPagarParcelaList = FXCollections.observableArrayList();
        this.loadTabela();
        this.tfDataLancamento.setValue((Object)LocalDate.now());
        this.tfFornecedorCodigo.requestFocus();
    }

    private void salva() {
        if (!this.validaForm()) {
            return;
        }
        try {
            this.contaPagarParcelaService.add(this.fornecedor, (CentroCusto)this.cbbCentroCusto.getSelectionModel().getSelectedItem(), (LocalDate)this.tfDataLancamento.getValue(), MaximaUtils.getText((String)this.tfNumeroNota.getText()), this.parcelas);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Conta(s) a pagar cadastrada(s) com sucesso.");
            Stage stage = (Stage)this.btnAddParcela.getScene().getWindow();
            stage.close();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: " + ex.getMessage()));
        }
    }

    private void addParcela() {
        if (!this.validaFormParcela()) {
            return;
        }
        if (this.parcelas == null) {
            this.parcelas = new ArrayList();
        }
        int nParcelas = MaximaNumber.toInt((String)this.tfQuantidade.getText());
        if (((LocalDate)this.tfDataVencimento.getValue()).isBefore(LocalDate.now()) && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Data de vencimento anterior a data atual. Deseja continuar?")) {
            return;
        }
        for (int i = 0; i < nParcelas; ++i) {
            LocalDate venc;
            ContaPagarParcela obj = new ContaPagarParcela();
            LocalDate primeiraParcela = (LocalDate)this.tfDataVencimento.getValue();
            Integer intervalo = MaximaNumber.toInt((String)this.tfIntervalo.getText());
            if (intervalo > 0) {
                venc = primeiraParcela.plusDays(intervalo * i);
                obj.setDataVencimento(venc);
            } else {
                venc = primeiraParcela.plusMonths(i);
                obj.setDataVencimento(venc);
            }
            obj.setDataEmissao(LocalDateTime.now());
            obj.setNumeroParcela("Parcela " + (i + 1));
            obj.setQuitado(false);
            obj.setIdentificador(Long.valueOf(new Date().getTime()));
            obj.setValor(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
            obj.setValorPendente(obj.getValor());
            obj.setHistorico(this.tfHistorico.getText());
            obj.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
            this.parcelas.add(obj);
        }
        this.loadTabela();
        this.limpaFormParcela();
    }

    private void deleteParcela() {
        ContaPagarParcela parc = (ContaPagarParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (parc == null) {
            return;
        }
        int count = 0;
        for (ContaPagarParcela parcela : this.parcelas) {
            if (parcela.getNumeroParcela().equals(parc.getNumeroParcela())) {
                System.out.println("== COUNT: " + count);
                this.parcelas.remove(count);
                break;
            }
            ++count;
        }
        this.loadTabela();
    }

    private void limpaFormParcela() {
        this.cbbFormaPagamento.getSelectionModel().select(null);
        this.tfDataVencimento.setValue(null);
        this.tfQuantidade.setText(null);
        this.tfIntervalo.setText(null);
        this.tfValor.setText(null);
        this.tfHistorico.setText(null);
    }

    private void setColumnProperties() {
        this.colVencimento.setCellValueFactory((Callback)new PropertyValueFactory("dataVencimento"));
        this.colHistorico.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colValor.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colVencimento.setCellFactory((Callback)new ColumnDateFormatter());
        this.colValor.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void loadTabela() {
        this.contaPagarParcelaList.clear();
        if (this.parcelas != null) {
            this.contaPagarParcelaList.addAll((Collection)this.parcelas);
            int cont = 1;
            for (ContaPagarParcela parc : this.parcelas) {
                parc.setNumeroParcela(String.valueOf(cont));
                ++cont;
            }
        }
        this.tabela.setItems(this.contaPagarParcelaList);
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValor);
    }

    private void pesquisaFornecedor() {
        String fornecedorCodigo = this.tfFornecedorCodigo.getText().trim();
        if (fornecedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long fornecedorCodigoNumero = Long.valueOf(fornecedorCodigo);
            Fornecedor fornecedorPesquisa = this.fornecedorService.getById(fornecedorCodigoNumero);
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaFornecedorForm();
    }

    private void pesquisaFornecedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorPesquisa.fxml", "Pesquisa de fornecedor");
            FornecedorPesquisaController controller = (FornecedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfFornecedorCodigo.getText().trim());
            stage.showAndWait();
            Fornecedor fornecedorPesquisa = controller.getFornecedorSelecionado();
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'FornecedorPesquisa'");
        }
    }

    private void loadDadosFornecedor() {
        if (this.fornecedor != null) {
            this.tfFornecedorCodigo.setText(this.fornecedor.getId().toString());
            this.tfFornecedorDescricao.setText(this.fornecedor.getNome().toUpperCase());
            this.tfDataLancamento.requestFocus();
        } else {
            this.tfFornecedorCodigo.setText("");
            this.tfFornecedorDescricao.setText("");
            this.tfFornecedorCodigo.requestFocus();
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.fornecedor == null) {
            this.tfFornecedorCodigo.getStyleClass().add((Object)"error");
            this.tfFornecedorDescricao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfFornecedorCodigo.getStyleClass().remove((Object)"error");
            this.tfFornecedorDescricao.getStyleClass().remove((Object)"error");
        }
        if (this.cbbCentroCusto.getSelectionModel().isEmpty()) {
            valido = false;
            this.cbbCentroCusto.getStyleClass().add((Object)"error");
        } else {
            this.cbbCentroCusto.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataLancamento.getValue() == null) {
            valido = false;
            this.tfDataLancamento.getStyleClass().add((Object)"error");
        } else {
            this.tfDataLancamento.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaFormParcela() {
        boolean valido = true;
        if (this.tfDataVencimento.getValue() == null) {
            valido = false;
            this.tfDataVencimento.getStyleClass().add((Object)"error");
        } else {
            this.tfDataVencimento.getStyleClass().remove((Object)"error");
        }
        int nParcelas = MaximaNumber.toInt((String)this.tfQuantidade.getText());
        if (nParcelas <= 0) {
            valido = false;
            this.tfQuantidade.getStyleClass().add((Object)"error");
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        BigDecimal valorParcela = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        if (valorParcela == null || valorParcela.compareTo(BigDecimal.ZERO) <= 0) {
            valido = false;
            this.tfValor.getStyleClass().add((Object)"error");
        } else {
            this.tfValor.getStyleClass().remove((Object)"error");
        }
        if (this.cbbFormaPagamento.getSelectionModel().isEmpty()) {
            valido = false;
            this.cbbFormaPagamento.getStyleClass().add((Object)"error");
        } else {
            this.cbbFormaPagamento.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
        this.cbbCentroCusto.setItems(FXCollections.observableArrayList((Collection)this.centroCustoService.combo()));
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFornecedor.setGraphic((Node)new MaximaIcone().getPesquisa());
        this.btnAddParcela.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnFornecedor.setOnAction(event -> this.pesquisaFornecedorForm());
        this.btnAddParcela.setOnAction(event -> this.addParcela());
        this.tfFornecedorCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaFornecedor();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteParcela();
            }
        });
    }
}

