/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ContaReceberEditaFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfClienteDescricao;
    @FXML
    private TextField tfValor;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private DatePicker tfDataLancamento;
    @FXML
    private DatePicker tfDataVencimento;
    @FXML
    private ComboBox<CentroCusto> cbbCentroCusto;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private Button btnSalva;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    @Autowired
    private CentroCustoService centroCustoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    @Lazy
    private StageManager stageManager;
    private ContaReceberParcela contaReceberParcela;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    public void inicializa(ContaReceberParcela cpp) {
        this.contaReceberParcela = this.contaReceberParcelaService.load(cpp.getId());
        this.tfClienteDescricao.setText(cpp.getCliente().getNome());
        this.tfDataLancamento.setValue((Object)cpp.getContaReceber().getDataDocumento());
        this.cbbCentroCusto.getSelectionModel().select((Object)cpp.getCentroCusto());
        this.tfNumeroNota.setText(cpp.getNumeroNota() == null || cpp.getNumeroNota().isEmpty() ? cpp.getContaReceber().getNumeroNota() : cpp.getNumeroNota());
        this.cbbFormaPagamento.getSelectionModel().select((Object)cpp.getFormaPagamento());
        this.tfDataVencimento.setValue((Object)cpp.getDataVencimento());
        this.tfValor.setText(MaximaNumber.bigDecimalToString((BigDecimal)cpp.getValor(), (int)2));
        this.tfHistorico.setText(cpp.getHistorico());
        VendaProduto venda = this.vendaProdutoService.getByContaReceber(cpp.getContaReceber());
        if (venda != null) {
            this.tfValor.setDisable(true);
        }
    }

    private void salva() {
        if (!this.valida()) {
            return;
        }
        this.contaReceberParcela.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        this.contaReceberParcela.setDataVencimento((LocalDate)this.tfDataVencimento.getValue());
        this.contaReceberParcela.setDataOperacao(LocalDateTime.now());
        this.contaReceberParcela.setValor(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
        this.contaReceberParcela.setValorPendente(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
        this.contaReceberParcela.setValorLiquido(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
        this.contaReceberParcela.setHistorico(MaximaUtils.getText((String)this.tfHistorico.getText()));
        this.contaReceberParcela.setCentroCusto((CentroCusto)this.cbbCentroCusto.getSelectionModel().getSelectedItem());
        this.contaReceberParcela.setNumeroNota(MaximaUtils.getText((String)this.tfNumeroNota.getText()));
        try {
            this.contaReceberParcelaService.salvaEdicao(this.contaReceberParcela);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Parcela alterada com sucesso.");
            this.close();
        }
        catch (MaximaValidacaoException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void close() {
        Stage form = (Stage)this.btnSalva.getScene().getWindow();
        form.close();
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValor);
    }

    private void carregaCombos() {
        this.cbbCentroCusto.setItems(FXCollections.observableArrayList((Collection)this.centroCustoService.combo()));
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }

    private boolean valida() {
        BigDecimal valorParcela;
        String msgError = "";
        if (this.tfDataVencimento.getValue() == null) {
            msgError = msgError + "Informe a data de vencimento para a parcela.\n";
        }
        if (this.cbbCentroCusto.getSelectionModel().getSelectedItem() == null) {
            msgError = msgError + "Selecione o centro de custo.\n";
        }
        if ((valorParcela = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText())) == null || valorParcela.compareTo(BigDecimal.ZERO) <= 0) {
            msgError = msgError + "Valor da parcela deve ser maior que zero.\n";
        }
        if (this.cbbFormaPagamento.getSelectionModel().getSelectedItem() == null) {
            msgError = msgError + "Selecione a forma de pagamento.\n";
        }
        if (!msgError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)msgError);
            return false;
        }
        return true;
    }
}

