/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ContaReceberFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfClienteCodigo;
    @FXML
    private TextField tfClienteDescricao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfIntervalo;
    @FXML
    private TextField tfValor;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private DatePicker tfDataLancamento;
    @FXML
    private DatePicker tfDataVencimento;
    @FXML
    private ComboBox<CentroCusto> cbbCentroCusto;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private TableView<ContaReceberParcela> tabela;
    @FXML
    private TableColumn<ContaReceberParcela, String> colVencimento;
    @FXML
    private TableColumn<ContaReceberParcela, String> colHistorico;
    @FXML
    private TableColumn<ContaReceberParcela, BigDecimal> colValor;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnCliente;
    @FXML
    private Button btnAddParcela;
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    @Autowired
    private CentroCustoService centroCustoService;
    private List<ContaReceberParcela> parcelas;
    private ObservableList<ContaReceberParcela> contaReceberParcelaList;
    private Cliente cliente;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
        this.setColumnProperties();
    }

    public void inicializa(ContaReceberParcela cpp) {
        this.contaReceberParcelaList = FXCollections.observableArrayList();
        this.parcelas = null;
        this.cliente = null;
        this.tfDataLancamento.setValue((Object)LocalDate.now());
        this.tfClienteCodigo.requestFocus();
        this.loadTabela();
    }

    private void salva() {
        if (!this.validaForm()) {
            return;
        }
        try {
            this.contaReceberParcelaService.add(this.cliente, (CentroCusto)this.cbbCentroCusto.getSelectionModel().getSelectedItem(), (LocalDate)this.tfDataLancamento.getValue(), MaximaUtils.getText((String)this.tfNumeroNota.getText()), this.parcelas);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Conta(s) a receber cadastrada(s) com sucesso.");
            Stage stage = (Stage)this.btnAddParcela.getScene().getWindow();
            stage.close();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(ContaReceberFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: " + ex.getMessage()));
        }
    }

    private void addParcela() {
        if (!this.validaFormParcela()) {
            return;
        }
        if (this.parcelas == null) {
            this.parcelas = new ArrayList();
        }
        int nParcelas = MaximaNumber.toInt((String)this.tfQuantidade.getText());
        if (((LocalDate)this.tfDataVencimento.getValue()).isBefore(LocalDate.now()) && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Data de vencimento anterior a data atual. Deseja continuar?")) {
            return;
        }
        for (int i = 0; i < nParcelas; ++i) {
            LocalDate venc;
            ContaReceberParcela obj = new ContaReceberParcela();
            LocalDate primeiraParcela = (LocalDate)this.tfDataVencimento.getValue();
            Integer intervalo = MaximaNumber.toInt((String)this.tfIntervalo.getText());
            if (intervalo > 0) {
                venc = primeiraParcela.plusDays(intervalo * i);
                obj.setDataVencimento(venc);
            } else {
                venc = primeiraParcela.plusMonths(i);
                obj.setDataVencimento(venc);
            }
            obj.setDataEmissao(LocalDateTime.now());
            obj.setNumeroParcela("Parcela " + (i + 1));
            obj.setQuitado(false);
            obj.setValor(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
            obj.setValorPendente(obj.getValor());
            obj.setValorLiquido(obj.getValor());
            obj.setHistorico(this.tfHistorico.getText());
            obj.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
            this.parcelas.add(obj);
        }
        this.loadTabela();
        this.limpaFormParcela();
    }

    private void deleteParcela() {
        ContaReceberParcela parc = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (parc == null) {
            return;
        }
        int count = 0;
        for (ContaReceberParcela parcela : this.parcelas) {
            if (parcela.getNumeroParcela().equals(parc.getNumeroParcela())) {
                System.out.println("== COUNT: " + count);
                this.parcelas.remove(count);
                break;
            }
            ++count;
        }
        this.loadTabela();
    }

    private void limpaFormParcela() {
        this.cbbFormaPagamento.getSelectionModel().select(null);
        this.tfDataVencimento.setValue(null);
        this.tfQuantidade.setText(null);
        this.tfIntervalo.setText(null);
        this.tfValor.setText(null);
        this.tfHistorico.setText(null);
    }

    private void setColumnProperties() {
        this.colVencimento.setCellValueFactory((Callback)new PropertyValueFactory("dataVencimento"));
        this.colHistorico.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colValor.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colVencimento.setCellFactory((Callback)new ColumnDateFormatter());
        this.colValor.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void loadTabela() {
        this.contaReceberParcelaList.clear();
        if (this.parcelas != null) {
            this.contaReceberParcelaList.addAll((Collection)this.parcelas);
            int cont = 1;
            for (ContaReceberParcela parc : this.parcelas) {
                parc.setNumeroParcela(String.valueOf(cont));
                ++cont;
            }
        }
        this.tabela.setItems(this.contaReceberParcelaList);
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValor);
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClienteCodigo.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                if (!clientePesquisa.getAtivo().booleanValue()) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Cliente desativado. N\u00e3o \u00e9 poss\u00edvel continuar.");
                    return;
                }
                this.cliente = clientePesquisa;
                this.loadDadosCliente();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaClienteForm();
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnCliente.getScene(), this.tfClienteCodigo.getText().trim());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClienteCodigo.setText(this.cliente.getId().toString());
            this.tfClienteDescricao.setText(this.cliente.getNome().toUpperCase());
            this.tfDataLancamento.requestFocus();
        } else {
            this.tfClienteCodigo.setText("");
            this.tfClienteDescricao.setText("");
            this.tfClienteCodigo.requestFocus();
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.cliente == null) {
            this.tfClienteCodigo.getStyleClass().add((Object)"error");
            this.tfClienteDescricao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfClienteCodigo.getStyleClass().remove((Object)"error");
            this.tfClienteDescricao.getStyleClass().remove((Object)"error");
        }
        if (this.cbbCentroCusto.getSelectionModel().isEmpty()) {
            valido = false;
            this.cbbCentroCusto.getStyleClass().add((Object)"error");
        } else {
            this.cbbCentroCusto.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataLancamento.getValue() == null) {
            valido = false;
            this.tfDataLancamento.getStyleClass().add((Object)"error");
        } else {
            this.tfDataLancamento.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaFormParcela() {
        boolean valido = true;
        if (this.tfDataVencimento.getValue() == null) {
            valido = false;
            this.tfDataVencimento.getStyleClass().add((Object)"error");
        } else {
            this.tfDataVencimento.getStyleClass().remove((Object)"error");
        }
        int nParcelas = MaximaNumber.toInt((String)this.tfQuantidade.getText());
        if (nParcelas <= 0) {
            valido = false;
            this.tfQuantidade.getStyleClass().add((Object)"error");
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        BigDecimal valorParcela = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        if (valorParcela == null || valorParcela.compareTo(BigDecimal.ZERO) <= 0) {
            valido = false;
            this.tfValor.getStyleClass().add((Object)"error");
        } else {
            this.tfValor.getStyleClass().remove((Object)"error");
        }
        if (this.cbbFormaPagamento.getSelectionModel().isEmpty()) {
            valido = false;
            this.cbbFormaPagamento.getStyleClass().add((Object)"error");
        } else {
            this.cbbFormaPagamento.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
        this.cbbCentroCusto.setItems(FXCollections.observableArrayList((Collection)this.centroCustoService.combo()));
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCliente.setGraphic((Node)new MaximaIcone().getPesquisa());
        this.btnAddParcela.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnCliente.setOnAction(event -> this.pesquisaClienteForm());
        this.btnAddParcela.setOnAction(event -> this.addParcela());
        this.tfClienteCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteParcela();
            }
        });
    }
}

