/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.controller.ContaPagarController;
import br.com.maximasolutions.financeiro.controller.MensalidadeFormController;
import br.com.maximasolutions.financeiro.modelo.Mensalidade;
import br.com.maximasolutions.financeiro.service.MensalidadeService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MensalidadeController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnGerar;
    @FXML
    private TableView<Mensalidade> tabela;
    @FXML
    private TableColumn<Mensalidade, String> colCliente;
    @FXML
    private TableColumn<Mensalidade, String> colData;
    @FXML
    private TableColumn<Mensalidade, String> colCondicaoRecebimento;
    @FXML
    private TableColumn<Mensalidade, BigDecimal> colTotal;
    @FXML
    private TextField tfInicio;
    @FXML
    private TextField tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MensalidadeService mensalidadeService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Mensalidade> mensalidadeList;

    public void initialize(URL url, ResourceBundle rb) {
        this.tfInicio.setText("01");
        this.tfFim.setText("30");
        this.mensalidadeList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.carregaIcones();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        MaximaMask.numericField((TextField)this.tfInicio);
        MaximaMask.numericField((TextField)this.tfFim);
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Mensalidade);
    }

    private void novo() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.carregaForm(null, "Cadastro de Mensalidade");
    }

    private void edita() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Mensalidade mensalidade = (Mensalidade)this.tabela.getSelectionModel().getSelectedItem();
        if (mensalidade == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma mensalidade para editar.");
            return;
        }
        this.carregaForm(mensalidade, "Edi\u00e7\u00e3o de mensalidade");
    }

    private void carregaForm(Mensalidade mensalidade, String titulo) {
        try {
            Stage formMensalidade = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/mensalidade/MensalidadeForm.fxml", titulo);
            MensalidadeFormController controller = (MensalidadeFormController)formMensalidade.getUserData();
            controller.inicializa(mensalidade);
            formMensalidade.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'MensalidadeForm'.\n");
        }
    }

    private void delete() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Mensalidade mensalidade = (Mensalidade)this.tabela.getSelectionModel().getSelectedItem();
        if (mensalidade == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma mensalidade para remover.");
            return;
        }
        if (!MaximaAlert.confirmacao((String)"Deseja remover a mensalidade selecionada?")) {
            return;
        }
        try {
            this.mensalidadeService.deleteById(mensalidade.getId());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Mensalidade removida com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(MensalidadeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void setColumnProperties() {
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("diaVencimento"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("valorAtual"));
        this.colCondicaoRecebimento.setCellValueFactory((Callback)new PropertyValueFactory("condicaoRecebimento"));
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        Integer fim;
        Integer inicio;
        this.mensalidadeList.clear();
        try {
            inicio = Integer.parseInt(this.tfInicio.getText());
            fim = Integer.parseInt(this.tfFim.getText());
            if (inicio > fim) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"O dia de in\u00edcio deve ser igual ou anterior a data final.");
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe o dia de in\u00edcio e fim para pesquisa.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.mensalidadeService.pesquisa(inicio, fim, filtro);
        this.mensalidadeList.addAll((Collection)list);
        this.tabela.setItems(this.mensalidadeList);
        this.lblTotal.setText("QTDE: " + list.size() + "                        VALOR TOTAL: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)this.mensalidadeService.total(inicio, fim, filtro), (int)2));
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnNovo.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void gerarContasReceber() {
        try {
            this.mensalidadeService.gerarContasReceber();
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Contas a receber geradas com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(MensalidadeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Falha ao gerar mensalidades.\n" + ex.getMessage()));
        }
    }

    private void registraAcoes() {
        this.btnGerar.setOnAction(evt -> this.gerarContasReceber());
        this.btnNovo.setOnAction(event -> this.novo());
        this.btnEdita.setOnAction(event -> this.edita());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.edita();
            }
        });
    }
}

