/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.modelo.Mensalidade;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.financeiro.service.MensalidadeService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MensalidadeFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfClienteCodigo;
    @FXML
    private TextField tfClienteDescricao;
    @FXML
    private TextField tfDataInicio;
    @FXML
    private TextField tfDiaVencimento;
    @FXML
    private TextField tfValorInicial;
    @FXML
    private TextField tfValorAtual;
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private ComboBox<CondicaoRecebimento> cbbCondicaoRecebimento;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnCliente;
    private Mensalidade mensalidade;
    private Cliente cliente;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private MensalidadeService mensalidadeService;
    @Autowired
    private CondicaoRecebimentoService condicaoRecebimentoService;
    @Autowired
    @Lazy
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaMascaras();
        this.carregaCombos();
    }

    public void inicializa(Mensalidade mensalidade) {
        this.mensalidade = mensalidade;
        this.tfClienteCodigo.requestFocus();
        this.load();
    }

    private void load() {
        if (this.mensalidade == null) {
            return;
        }
        this.ccbAtivo.setSelected(this.mensalidade.getAtivo().booleanValue());
        this.cliente = this.mensalidade.getCliente();
        this.tfDataInicio.setText(MaximaDate.getData((LocalDate)this.mensalidade.getDataInicio()));
        this.tfDiaVencimento.setText(this.mensalidade.getDiaVencimento().toString());
        this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.mensalidade.getUltimaAlteracao()));
        this.tfValorAtual.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.mensalidade.getValorAtual(), (int)2));
        this.tfValorInicial.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.mensalidade.getValorInicial(), (int)2));
        this.cbbCondicaoRecebimento.getSelectionModel().select((Object)this.mensalidade.getCondicaoRecebimento());
        this.loadDadosCliente();
    }

    private void getMensalidade() {
        if (this.mensalidade == null) {
            this.mensalidade = new Mensalidade();
        }
        this.mensalidade.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        this.mensalidade.setCliente(this.cliente);
        this.mensalidade.setDataInicio(MaximaDate.convertToLocalDate((String)this.tfDataInicio.getText()));
        this.mensalidade.setDiaVencimento(Integer.valueOf(Integer.parseInt(this.tfDiaVencimento.getText())));
        this.mensalidade.setUltimaAlteracao(LocalDateTime.now());
        this.mensalidade.setValorAtual(MaximaNumber.moneyToBigDecimal((String)this.tfValorAtual.getText()));
        this.mensalidade.setValorInicial(MaximaNumber.moneyToBigDecimal((String)this.tfValorInicial.getText()));
        this.mensalidade.setCondicaoRecebimento((CondicaoRecebimento)this.cbbCondicaoRecebimento.getSelectionModel().getSelectedItem());
    }

    private void salva() {
        this.getMensalidade();
        if (!this.validaForm()) {
            return;
        }
        try {
            this.mensalidadeService.save(this.mensalidade);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Mensalidade cadastrada com sucesso.");
            Stage stage = (Stage)this.btnSalva.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(MensalidadeFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: " + ex.getMessage()));
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValorInicial);
        MaximaMask.monetaryField((TextField)this.tfValorAtual);
        MaximaMask.dateField((TextField)this.tfDataInicio);
        MaximaMask.numericField((TextField)this.tfDiaVencimento);
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClienteCodigo.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                this.cliente = clientePesquisa;
                this.loadDadosCliente();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaClienteForm();
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnCliente.getScene(), this.tfClienteCodigo.getText());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClienteCodigo.setText(this.cliente.getId().toString());
            this.tfClienteDescricao.setText(this.cliente.getNome().toUpperCase());
            this.tfDataInicio.requestFocus();
        } else {
            this.tfClienteCodigo.setText("");
            this.tfClienteDescricao.setText("");
            this.tfClienteCodigo.requestFocus();
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.cliente == null) {
            this.tfClienteCodigo.getStyleClass().add((Object)"error");
            this.tfClienteDescricao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfClienteCodigo.getStyleClass().remove((Object)"error");
            this.tfClienteDescricao.getStyleClass().remove((Object)"error");
        }
        if (this.mensalidade.getDataInicio() == null) {
            valido = false;
            this.tfDataInicio.getStyleClass().add((Object)"error");
        } else {
            this.tfDataInicio.getStyleClass().remove((Object)"error");
        }
        if (this.mensalidade.getDiaVencimento() == null) {
            valido = false;
            this.tfDiaVencimento.getStyleClass().add((Object)"error");
        } else {
            this.tfDiaVencimento.getStyleClass().remove((Object)"error");
        }
        if (this.mensalidade.getValorInicial() == null) {
            valido = false;
            this.tfValorInicial.getStyleClass().add((Object)"error");
        } else {
            this.tfValorInicial.getStyleClass().remove((Object)"error");
        }
        if (this.mensalidade.getValorAtual() == null) {
            valido = false;
            this.tfValorAtual.getStyleClass().add((Object)"error");
        } else {
            this.tfValorAtual.getStyleClass().remove((Object)"error");
        }
        if (this.mensalidade.getCondicaoRecebimento() == null) {
            valido = false;
            this.cbbCondicaoRecebimento.getStyleClass().add((Object)"error");
        } else {
            this.cbbCondicaoRecebimento.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCliente.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void carregaCombos() {
        this.cbbCondicaoRecebimento.setItems(FXCollections.observableArrayList((Collection)this.condicaoRecebimentoService.pesquisa("")));
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnCliente.setOnAction(event -> this.pesquisaClienteForm());
        this.tfClienteCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
    }
}

