/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaFechaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaIniciaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaSangriaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaSuprimentoFormController;
import br.com.maximasolutions.financeiro.modelo.Caixa;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.relatorio.controller.RelatorioMovimentoCaixaExtratoController;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentacaoEntradaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.javafx.formatter.ColumnDateTimeFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MovimentoCaixaController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnAbrirCaixa;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnFecha;
    @FXML
    private Button btnImprime;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnSangria;
    @FXML
    private Button btnSuprimento;
    @FXML
    private Button btnVisualiza;
    @FXML
    private TableView<MovimentoCaixa> tabela;
    @FXML
    private TableColumn<MovimentoCaixa, String> colDataAbertura;
    @FXML
    private TableColumn<MovimentoCaixa, String> colSaldoAbertura;
    @FXML
    private TableColumn<MovimentoCaixa, String> colTotalEmCaixa;
    @FXML
    private TableColumn<MovimentoCaixa, String> colTotalVendido;
    @FXML
    private TableColumn<MovimentoCaixa, String> colRecebimentos;
    @FXML
    private TableColumn<MovimentoCaixa, String> colPagamentos;
    @FXML
    private TableColumn<MovimentoCaixa, String> colSangria;
    @FXML
    private TableColumn<MovimentoCaixa, String> colSuprimento;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private ComboBox<Caixa> cbbCaixa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private MovimentacaoEntradaService movimentacaoEntradaService;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    private ObservableList<MovimentoCaixa> movimentoCaixaList;

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.MovimentoCaixa);
        String caixaId = MaximaConfig.getInstance().getProperty("caixa_id", "1");
        if (caixaId == null || caixaId.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum caixa configurado.");
            return;
        }
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.carregaBotoes();
        this.registraAcoes();
        this.carregaIcones();
        this.movimentoCaixaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.carregaCombos();
        this.loadTabela();
    }

    private void abrirCaixa() {
        System.out.println("== Abertura caixa valida permiss\u00e3o.");
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.CAIXA_ABRIR).booleanValue()) {
            return;
        }
        System.out.println("== Permissao validada com sucesso.");
        if (this.cbbCaixa.getSelectionModel().getSelectedItem() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um caixa abrir o movimento di\u00e1rio.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/AbrirCaixaForm.fxml", "Abrtura de Caixa");
            MovimentoCaixaIniciaFormController controller = (MovimentoCaixaIniciaFormController)stage.getUserData();
            controller.inicializa((Caixa)this.cbbCaixa.getSelectionModel().getSelectedItem());
            stage.showAndWait();
            this.loadTabela();
        }
        catch (Exception ex) {
            Logger.getLogger(MovimentoCaixaController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de abertura de caixa.");
        }
    }

    private void suprimento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.CAIXA_SUPRIMENTO).booleanValue()) {
            return;
        }
        if (this.cbbCaixa.getSelectionModel().getSelectedItem() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um caixa para efetuar o suprimento.");
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/SuprimentoForm.fxml", "Suprimento");
            MovimentoCaixaSuprimentoFormController controller = (MovimentoCaixaSuprimentoFormController)form.getUserData();
            controller.inicializa((Caixa)this.cbbCaixa.getSelectionModel().getSelectedItem());
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(MovimentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo: 'SangriaForm.fxml'.");
        }
    }

    private void sangria() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.CAIXA_SANGRIA).booleanValue()) {
            return;
        }
        if (this.cbbCaixa.getSelectionModel().getSelectedItem() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um caixa para efetuar a sangria.");
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/SangriaForm.fxml", "Sangria");
            MovimentoCaixaSangriaFormController controller = (MovimentoCaixaSangriaFormController)form.getUserData();
            controller.inicializa((Caixa)this.cbbCaixa.getSelectionModel().getSelectedItem());
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(MovimentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo: 'SangriaForm.fxml'.");
        }
    }

    private void imprimeMovimentoCaixa() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.CAIXA_IMPRIMIR).booleanValue()) {
            return;
        }
        MovimentoCaixa movimentoCaixa = (MovimentoCaixa)this.tabela.getSelectionModel().getSelectedItem();
        if (movimentoCaixa == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um movimento de caixa para imprimir.");
            return;
        }
        try {
            this.movimentoCaixaService.imprime(movimentoCaixa.getId());
        }
        catch (MaximaValidacaoException maximaValidacaoException) {
            Logger.getLogger(MovimentoCaixaController.class.getSimpleName()).log(Level.SEVERE, null, maximaValidacaoException);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ops, falha ao imprimir fechamento de caixa.\n" + maximaValidacaoException.getMessage()));
        }
    }

    private void visualizaMovimentoCaixa() {
        MovimentoCaixa movimentoCaixa = (MovimentoCaixa)this.tabela.getSelectionModel().getSelectedItem();
        if (movimentoCaixa == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um movimento de caixa para visualizar.");
            return;
        }
        movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaService.find(movimentoCaixa.getId());
        try {
            List recebimentos = this.movimentoCaixaService.lista(movimentoCaixa);
            recebimentos.forEach(rec -> System.out.println("=== rec: " + rec.getValor()));
            new RelatorioMovimentoCaixaExtratoController().geraRelatorio(movimentoCaixa, recebimentos, this.configuracaoService.load());
        }
        catch (MaximaException ex) {
            Logger.getLogger(MovimentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void delete() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        MovimentoCaixa movimentoCaixa = (MovimentoCaixa)this.tabela.getSelectionModel().getSelectedItem();
        if (movimentoCaixa == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um caixa para remover.");
            return;
        }
        boolean confirma = MaximaAlert.confirmacao((String)"Deseja remover o caixa selecionado?");
        if (confirma) {
            this.movimentoCaixaService.delete((Object)movimentoCaixa);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Caixa removido com sucesso.");
            this.loadTabela();
        }
    }

    private void setColumnProperties() {
        this.colDataAbertura.setCellValueFactory((Callback)new PropertyValueFactory("dataAbertura"));
        this.colSaldoAbertura.setCellValueFactory((Callback)new PropertyValueFactory("saldoAbertura"));
        this.colTotalEmCaixa.setCellValueFactory((Callback)new PropertyValueFactory("valorEmCaixa"));
        this.colTotalVendido.setCellValueFactory((Callback)new PropertyValueFactory("totalVendas"));
        this.colRecebimentos.setCellValueFactory((Callback)new PropertyValueFactory("recebimentos"));
        this.colPagamentos.setCellValueFactory((Callback)new PropertyValueFactory("pagamentos"));
        this.colSangria.setCellValueFactory((Callback)new PropertyValueFactory("sangria"));
        this.colSuprimento.setCellValueFactory((Callback)new PropertyValueFactory("suprimento"));
        ColumnNumberFormatter numberFormatter = new ColumnNumberFormatter();
        ColumnNumberFormatter numberBoldFormatter = new ColumnNumberFormatter();
        numberBoldFormatter.setNegrito(Boolean.TRUE);
        this.colDataAbertura.setCellFactory((Callback)new ColumnDateTimeFormatter());
        this.colSaldoAbertura.setCellFactory((Callback)numberFormatter);
        this.colTotalEmCaixa.setCellFactory((Callback)numberBoldFormatter);
        this.colTotalVendido.setCellFactory((Callback)numberFormatter);
        this.colRecebimentos.setCellFactory((Callback)numberFormatter);
        this.colPagamentos.setCellFactory((Callback)numberFormatter);
        this.colSangria.setCellFactory((Callback)numberFormatter);
        this.colSuprimento.setCellFactory((Callback)numberFormatter);
    }

    private void loadTabela() {
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        this.movimentoCaixaList.clear();
        LocalDateTime dataInicio = inicio.atTime(0, 0, 0, 0);
        LocalDateTime dataFim = fim.atTime(23, 59, 59, 59);
        List list = this.movimentoCaixaService.lista(dataInicio, dataFim, (Caixa)this.cbbCaixa.getSelectionModel().getSelectedItem());
        this.movimentoCaixaList.addAll((Collection)list);
        this.tabela.setItems(this.movimentoCaixaList);
        this.carregaBotoes();
    }

    private void carregaIcones() {
        this.btnAbrirCaixa.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
        this.btnImprime.setGraphic((Node)new MaximaIcone().print());
        this.btnFecha.setGraphic((Node)new MaximaIcone().fechamentoCaixa());
    }

    private void registraAcoes() {
        this.cbbCaixa.valueProperty().addListener((obs, oldItem, newItem) -> this.loadTabela());
        this.btnAbrirCaixa.setOnAction(event -> this.abrirCaixa());
        this.btnSangria.setOnAction(event -> this.sangria());
        this.btnSuprimento.setOnAction(event -> this.suprimento());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.btnImprime.setOnAction(t -> this.imprimeMovimentoCaixa());
        this.btnVisualiza.setOnAction(t -> this.visualizaMovimentoCaixa());
        this.btnFecha.setOnAction(t -> {
            Caixa caixa = (Caixa)this.cbbCaixa.getSelectionModel().getSelectedItem();
            if (caixa == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um caixa para fechar.");
                return;
            }
            try {
                MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixa.getId().longValue());
                if (movimentoCaixa == null) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum movimento de caixa aberto.");
                    return;
                }
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/FecharCaixaForm.fxml", "Fechamento de Caixa");
                MovimentoCaixaFechaFormController controller = (MovimentoCaixaFechaFormController)stage.getUserData();
                controller.inicializa(caixa);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(MovimentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir form de fechamento de caixa.");
            }
        });
    }

    private void carregaBotoes() {
        Caixa caixa = (Caixa)this.cbbCaixa.getSelectionModel().getSelectedItem();
        if (caixa == null) {
            this.btnAbrirCaixa.setDisable(true);
            this.btnFecha.setDisable(true);
            this.btnSangria.setDisable(true);
            this.btnSuprimento.setDisable(true);
            this.btnImprime.setDisable(true);
            this.btnVisualiza.setDisable(true);
        } else {
            MovimentoCaixa caixaAberto = this.movimentoCaixaService.getCaixaAberto(caixa.getId().longValue());
            this.btnSangria.setDisable(false);
            this.btnSuprimento.setDisable(false);
            this.btnImprime.setDisable(false);
            this.btnVisualiza.setDisable(false);
            if (caixaAberto != null) {
                this.btnAbrirCaixa.setDisable(true);
                this.btnFecha.setDisable(false);
            } else {
                this.btnAbrirCaixa.setDisable(false);
                this.btnFecha.setDisable(true);
            }
        }
    }

    private void carregaCombos() {
        List caixas = this.caixaService.lista();
        ArrayList listaCombo = new ArrayList();
        Caixa selecionado = null;
        if (caixas.size() > 1) {
            listaCombo.add(null);
        }
        if (caixas.size() == 1) {
            selecionado = (Caixa)caixas.get(0);
        }
        listaCombo.addAll(caixas);
        this.cbbCaixa.setItems(FXCollections.observableArrayList(listaCombo));
        this.cbbCaixa.getSelectionModel().select((Object)selecionado);
    }
}

