/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.Caixa;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentacaoEntradaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.food.service.MesaService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MovimentoCaixaFechaFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfDataAbertura;
    @FXML
    private TextField tfHoraAbertura;
    @FXML
    private TextField tfSaldoAbertura;
    @FXML
    private TextField tfTotalCaixa;
    @FXML
    private Button btnSalva;
    private MovimentoCaixa movimentoCaixa;
    private Caixa caixa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private MesaService mesaService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private MovimentacaoEntradaService movimentacaoEntradaService;
    private boolean sucesso;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setMascaras();
        this.registraAcoes();
    }

    public boolean isSucesso() {
        return this.sucesso;
    }

    public void inicializa(Caixa caixa) {
        this.sucesso = false;
        this.caixa = caixa == null ? this.caixaService.find(Long.valueOf(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")))) : this.caixaService.find(caixa.getId());
        this.movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixa.getId().longValue());
        System.out.println("===== movimento caixa: " + this.movimentoCaixa);
        this.tfSaldoAbertura.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.movimentoCaixa.getSaldoAbertura(), (int)2));
        this.tfDataAbertura.setText(this.movimentoCaixa.getDataAbertura().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
        this.tfHoraAbertura.setText(this.movimentoCaixa.getDataAbertura().format(DateTimeFormatter.ofPattern("HH:mm:ss")));
        this.tfTotalCaixa.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.movimentoCaixa.getValorEmCaixa(), (int)2));
    }

    private void finalizaCaixa() {
        if (this.movimentoCaixa != null) {
            if (this.mesaService.listaOcupadas().size() > 0 && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Existe comandas em aberto. Deseja encerrar o caixa mesmo assim?")) {
                return;
            }
            try {
                this.movimentoCaixaService.finaliza(this.movimentoCaixa);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Movimento de caixa finalizado com sucesso.");
                if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja imprimir o fechamento de caixa?")) {
                    this.imprimeMovimentoCaixa(this.movimentoCaixa);
                }
                this.sucesso = true;
                Stage stage = (Stage)this.btnSalva.getScene().getWindow();
                stage.close();
            }
            catch (MaximaException ex) {
                Logger.getLogger(MovimentoCaixaFechaFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
            }
        }
    }

    private void imprimeMovimentoCaixa(MovimentoCaixa movimentoCaixa) {
        try {
            this.movimentoCaixaService.imprime(movimentoCaixa.getId());
        }
        catch (MaximaValidacaoException maximaValidacaoException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ops, ocorreu uma falha ao imprimir fechamento de caixa.");
        }
    }

    public void setMovimentoCaixa(MovimentoCaixa movimentoCaixa1) {
        this.movimentoCaixa = movimentoCaixa1;
        if (this.movimentoCaixa != null) {
            // empty if block
        }
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.finalizaCaixa());
    }

    private void setMascaras() {
        MaximaMask.dateField((TextField)this.tfDataAbertura);
        MaximaMask.horaField((TextField)this.tfHoraAbertura);
        MaximaMask.monetaryField((TextField)this.tfSaldoAbertura);
        MaximaMask.monetaryField((TextField)this.tfTotalCaixa);
    }
}

