/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.Caixa;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.printer.MovimentoCaixaPrinter;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.print.PrintException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MovimentoCaixaIniciaFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfDataAbertura;
    @FXML
    private TextField tfHoraAbertura;
    @FXML
    private TextField tfSaldoAbertura;
    @FXML
    private Button btnSalva;
    private MovimentoCaixa movimentoCaixa;
    private Caixa caixa;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Lazy
    @Autowired
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setMascaras();
        this.registraAcoes();
        this.tfDataAbertura.setText(LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
        this.tfHoraAbertura.setText(LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss")));
    }

    public void inicializa(Caixa caixa) {
        System.out.println("===== caixa: " + caixa);
        this.caixa = caixa == null ? this.caixaService.find(Long.valueOf(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "0")))) : this.caixaService.find(caixa.getId());
        this.movimentoCaixa = null;
        System.out.println("==== INICIALIZAR CAIXA: " + caixa);
    }

    private void iniciaCaixa() {
        if (this.caixa == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum caixa selecionado.");
            return;
        }
        this.movimentoCaixa = this.getMovimentoCaixa();
        if (this.movimentoCaixa.getId() == null) {
            this.movimentoCaixa.setValorEmCaixa(this.movimentoCaixa.getSaldoAbertura());
            try {
                this.movimentoCaixa = this.movimentoCaixaService.inicia(this.movimentoCaixa);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Caixa inicializado com sucesso.");
                if (this.movimentoCaixa != null && this.movimentoCaixa.getId() != null && MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja imprimir o comprovante de abertura de caixa?")) {
                    this.imprimeAberturaCaixa(this.movimentoCaixa);
                }
            }
            catch (MaximaException ex) {
                Logger.getLogger(MovimentoCaixaIniciaFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void imprimeAberturaCaixa(MovimentoCaixa movimentoCaixa) {
        try {
            new MovimentoCaixaPrinter().imprimeAberturaCaixa(movimentoCaixa, this.configuracaoService.load());
        }
        catch (MaximaValidacaoException | PrintException ex) {
            Logger.getLogger(MovimentoCaixaIniciaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao imprimir fechamento de caixa.");
        }
    }

    private MovimentoCaixa getMovimentoCaixa() {
        if (this.movimentoCaixa == null) {
            this.movimentoCaixa = new MovimentoCaixa();
        }
        this.movimentoCaixa.setDataAbertura(MaximaDate.convertToLocalDateTime((String)(this.tfDataAbertura.getText().trim() + " " + this.tfHoraAbertura.getText().trim())));
        this.movimentoCaixa.setSaldoAbertura(MaximaNumber.moneyToBigDecimal((String)this.tfSaldoAbertura.getText()));
        this.movimentoCaixa.setCaixa(this.caixa);
        return this.movimentoCaixa;
    }

    public void setMovimentoCaixa(MovimentoCaixa movimentoCaixa1) {
        this.movimentoCaixa = movimentoCaixa1;
        if (this.movimentoCaixa != null) {
            // empty if block
        }
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.iniciaCaixa());
    }

    private void setMascaras() {
        MaximaMask.dateField((TextField)this.tfDataAbertura);
        MaximaMask.horaField((TextField)this.tfHoraAbertura);
        MaximaMask.monetaryField((TextField)this.tfSaldoAbertura);
    }
}

