/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.modelo.Caixa;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MovimentoCaixaSuprimentoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfValor;
    @FXML
    private TextField tfDescricao;
    @FXML
    private ComboBox<FormaPagamento> cbbTipo;
    @FXML
    private Button btnSalva;
    private MovimentoCaixa movimentoCaixa;
    private Caixa caixa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private CaixaService caixaService;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setMascaras();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa(Caixa caixa) {
        this.caixa = caixa == null ? this.caixaService.find(Long.valueOf(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "0")))) : this.caixaService.find(caixa.getId());
        this.movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(this.caixa.getId().longValue());
        this.tfValor.setText("");
        this.tfValor.requestFocus();
        this.tfValor.selectAll();
    }

    private void finalizaCaixa() {
        if (this.movimentoCaixa != null) {
            this.movimentoCaixaService.suprimento(this.movimentoCaixa, MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()), (FormaPagamento)this.cbbTipo.getSelectionModel().getSelectedItem(), MaximaUtils.getText((String)this.tfDescricao.getText()));
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Suprimento realizado com sucesso.");
            Stage stage = (Stage)this.btnSalva.getScene().getWindow();
            stage.close();
        }
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void carregaCombos() {
        ArrayList<FormaPagamento> list = new ArrayList<FormaPagamento>();
        list.add(FormaPagamento.DINHEIRO);
        list.add(FormaPagamento.CHEQUE);
        this.cbbTipo.setItems(FXCollections.observableArrayList(list));
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.finalizaCaixa());
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValor);
    }
}

