/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.controller.PagamentoFormController;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.Conta;
import br.com.maximasolutions.financeiro.modelo.ContaPagar;
import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoSaida;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.financeiro.service.ContaService;
import br.com.maximasolutions.financeiro.service.MovimentacaoSaidaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.geral.controller.FornecedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PagamentoDiretoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfFornecedorCodigo;
    @FXML
    private TextField tfFornecedorDescricao;
    @FXML
    private TextField tfDesconto;
    @FXML
    private TextField tfJuros;
    @FXML
    private TextField tfValor;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private DatePicker tfDataLancamento;
    @FXML
    private DatePicker tfDataVencimento;
    @FXML
    private ComboBox<CentroCusto> cbbCentroCusto;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private ComboBox<Conta> cbbContaMovimento;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFornecedor;
    private Fornecedor fornecedor;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private MovimentacaoSaidaService movimentacaoSaidaService;
    @Autowired
    private CentroCustoService centroCustoService;
    @Autowired
    private ContaService contaService;
    @Autowired
    @Lazy
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.tfDataLancamento.setValue((Object)LocalDate.now());
        this.tfDataVencimento.setValue((Object)LocalDate.now());
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    public void inicializa(ContaPagarParcela cpp) {
        this.tfDataLancamento.setValue((Object)LocalDate.now());
        this.tfFornecedorCodigo.requestFocus();
    }

    private void salva() {
        Boolean lancarMovimentoCaixa;
        if (!this.valida()) {
            return;
        }
        try {
            lancarMovimentoCaixa = MaximaAlert.SIM_NAO_CANCELA((StageManager)this.stageManager, (String)"Deseja lan\u00e7ar o pagamento no movimento de caixa?");
        }
        catch (MaximaValidacaoException ex) {
            return;
        }
        try {
            ContaPagar contaPagar = this.createContaPagar();
            ContaPagarParcela parcela = this.createParcela(contaPagar);
            this.movimentacaoSaidaService.pagamentoDireto(contaPagar, parcela, this.createPagamento(parcela), lancarMovimentoCaixa, (Conta)this.cbbContaMovimento.getSelectionModel().getSelectedItem());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Pagamento efetuado com sucesso.");
            Stage stage = (Stage)this.btnSalva.getScene().getWindow();
            stage.close();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(PagamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValor);
        MaximaMask.monetaryField((TextField)this.tfDesconto);
        MaximaMask.monetaryField((TextField)this.tfJuros);
        MaximaMask.monetaryField((TextField)this.tfValorTotal);
    }

    private void pesquisaFornecedor() {
        String fornecedorCodigo = this.tfFornecedorCodigo.getText().trim();
        if (fornecedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long fornecedorCodigoNumero = Long.valueOf(fornecedorCodigo);
            Fornecedor fornecedorPesquisa = this.fornecedorService.getById(fornecedorCodigoNumero);
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaFornecedorForm();
    }

    private void pesquisaFornecedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorPesquisa.fxml", "Pesquisa de fornecedor");
            FornecedorPesquisaController controller = (FornecedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfFornecedorCodigo.getText().trim());
            stage.showAndWait();
            Fornecedor fornecedorPesquisa = controller.getFornecedorSelecionado();
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PagamentoDiretoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'FornecedorPesquisa'");
        }
    }

    private void loadDadosFornecedor() {
        if (this.fornecedor != null) {
            this.tfFornecedorCodigo.setText(this.fornecedor.getId().toString());
            this.tfFornecedorDescricao.setText(this.fornecedor.getNome().toUpperCase());
            this.tfDataLancamento.requestFocus();
        } else {
            this.tfFornecedorCodigo.setText("");
            this.tfFornecedorDescricao.setText("");
            this.tfFornecedorCodigo.requestFocus();
        }
    }

    private void carregaCombos() {
        this.cbbCentroCusto.setItems(FXCollections.observableArrayList((Collection)this.centroCustoService.combo()));
        this.cbbContaMovimento.setItems(FXCollections.observableArrayList((Collection)this.contaService.combo()));
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFornecedor.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void calculaTotal() {
        BigDecimal valorParcela = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        BigDecimal desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        BigDecimal juros = MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText());
        if (valorParcela == null) {
            return;
        }
        if (desconto == null) {
            desconto = BigDecimal.ZERO;
        }
        if (juros == null) {
            juros = BigDecimal.ZERO;
        }
        BigDecimal total = valorParcela.subtract(desconto).add(juros);
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnFornecedor.setOnAction(event -> this.pesquisaFornecedorForm());
        this.tfFornecedorCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaFornecedor();
            }
        });
        this.tfValor.setOnKeyReleased(t -> this.calculaTotal());
        this.tfDesconto.setOnKeyReleased(t -> this.calculaTotal());
        this.tfJuros.setOnKeyReleased(t -> this.calculaTotal());
    }

    private boolean valida() {
        String msgError = "";
        Boolean valido = true;
        if (this.fornecedor == null) {
            this.tfFornecedorCodigo.getStyleClass().add((Object)"error");
            this.tfFornecedorDescricao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfFornecedorCodigo.getStyleClass().remove((Object)"error");
            this.tfFornecedorDescricao.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataLancamento.getValue() == null) {
            this.tfDataLancamento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataLancamento.getStyleClass().remove((Object)"error");
        }
        if (this.cbbCentroCusto.getSelectionModel().getSelectedItem() == null) {
            this.cbbCentroCusto.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbCentroCusto.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataVencimento.getValue() == null) {
            this.tfDataVencimento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataVencimento.getStyleClass().remove((Object)"error");
        }
        BigDecimal valorParcela = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        if (valorParcela == null || valorParcela.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfValor.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfValor.getStyleClass().remove((Object)"error");
        }
        BigDecimal valorTotal = MaximaNumber.moneyToBigDecimal((String)this.tfValorTotal.getText());
        if (valorTotal == null || valorTotal.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfValorTotal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfValorTotal.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private ContaPagar createContaPagar() {
        ContaPagar contaPagar = new ContaPagar();
        contaPagar.setCentroCusto((CentroCusto)this.cbbCentroCusto.getSelectionModel().getSelectedItem());
        contaPagar.setFornecedor(this.fornecedor);
        contaPagar.setNumeroNota(MaximaUtils.getText((String)this.tfNumeroNota.getText()));
        contaPagar.setDataDocumento(LocalDate.now());
        return contaPagar;
    }

    private ContaPagarParcela createParcela(ContaPagar contaPagar) {
        ContaPagarParcela parcela = new ContaPagarParcela();
        parcela.setCentroCusto(contaPagar.getCentroCusto());
        parcela.setDataEmissao(LocalDateTime.now());
        parcela.setDataOperacao(LocalDateTime.now());
        parcela.setDataPagamento((LocalDate)this.tfDataVencimento.getValue());
        parcela.setDataVencimento((LocalDate)this.tfDataVencimento.getValue());
        parcela.setExcluido(Boolean.valueOf(false));
        parcela.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        parcela.setFornecedor(contaPagar.getFornecedor());
        parcela.setHistorico(MaximaUtils.getText((String)this.tfHistorico.getText()));
        parcela.setNumeroNota(contaPagar.getNumeroNota());
        parcela.setNumeroParcela("1/1");
        parcela.setPagamentoEstornado(Boolean.valueOf(false));
        parcela.setQuitado(true);
        parcela.setValor(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
        parcela.setValorPendente(BigDecimal.ZERO);
        parcela.setValorLiquido(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
        return parcela;
    }

    private MovimentacaoSaida createPagamento(ContaPagarParcela contaPagarParcela) {
        MovimentacaoSaida pagto = new MovimentacaoSaida();
        pagto.setDireto(Boolean.valueOf(true));
        pagto.setFornecedor(this.fornecedor);
        pagto.setContaPagarParcela(contaPagarParcela);
        pagto.setDataOperacao(LocalDateTime.now());
        pagto.setDataMovimento((LocalDate)this.tfDataVencimento.getValue());
        pagto.setDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()));
        pagto.setEstornada(Boolean.FALSE);
        pagto.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        pagto.setHistorico(MaximaUtils.getText((String)this.tfHistorico.getText()));
        pagto.setJuros(MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText()));
        pagto.setTotal(MaximaNumber.moneyToBigDecimal((String)this.tfValorTotal.getText()));
        pagto.setValor(pagto.getTotal().add(pagto.getDesconto()).subtract(pagto.getJuros()));
        return pagto;
    }
}

