/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.relatorio.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.relatorio.controller.RelatorioContaReceberController;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioContaReceberController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private CentroCustoService centroCustoService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnClientePesquisa;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfClientePesquisa;
    @FXML
    private TextField tfClienteNome;
    @FXML
    private ComboBox<CentroCusto> cbbCentroCusto;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    private BigDecimal total;
    private BigDecimal valor;
    private BigDecimal juros;
    private BigDecimal desconto;
    private Cliente cliente;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.cliente = null;
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        Stage progress = new MaximaDialogFX().progress(this.stageManager, "Gerando relat\u00f3rio.......");
        progress.show();
        this.exibeRelatorio(progress);
    }

    private void exibeRelatorio(Stage progress) {
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$exibeRelatorio$0(progress, (Service)service, arg_0));
        service.start();
    }

    private void calculaTotal(List<ContaReceberParcela> parcelas) {
        this.valor = BigDecimal.ZERO;
        this.juros = BigDecimal.ZERO;
        this.desconto = BigDecimal.ZERO;
        this.total = BigDecimal.ZERO;
        parcelas.stream().forEachOrdered(rec -> {
            this.valor = this.valor.add(rec.getValor());
            this.juros = this.juros.add(rec.getJuros());
            this.desconto = this.desconto.add(rec.getDesconto());
            this.total = this.total.add(rec.getTotal());
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnClientePesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.tfClientePesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.btnClientePesquisa.setOnAction(event -> this.pesquisaClienteForm());
    }

    private void loadCombos() {
        this.cbbCentroCusto.setItems(FXCollections.observableArrayList((Collection)this.centroCustoService.combo()));
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Object[])FormaPagamento.values()));
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClientePesquisa.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                this.cliente = clientePesquisa;
            } else {
                this.cliente = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de cliente n\u00e3o encontrado.");
                this.tfClientePesquisa.requestFocus();
                this.tfClientePesquisa.selectAll();
            }
            this.loadDadosCliente();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaClienteForm();
            return;
        }
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnClientePesquisa.getScene(), this.tfClientePesquisa.getText());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClientePesquisa.setText(this.cliente.getId().toString());
            this.tfClienteNome.setText(this.cliente.getNome().toUpperCase());
        } else {
            this.tfClienteNome.setText("");
            this.tfClientePesquisa.setText("");
            this.tfClientePesquisa.requestFocus();
        }
    }

    private /* synthetic */ void lambda$exibeRelatorio$0(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (!retorno.getSucesso().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ DatePicker access$000(RelatorioContaReceberController x0) {
        return x0.tfDataInicial;
    }

    static /* synthetic */ DatePicker access$100(RelatorioContaReceberController x0) {
        return x0.tfDataFinal;
    }

    static /* synthetic */ Cliente access$200(RelatorioContaReceberController x0) {
        return x0.cliente;
    }

    static /* synthetic */ ComboBox access$300(RelatorioContaReceberController x0) {
        return x0.cbbCentroCusto;
    }

    static /* synthetic */ ComboBox access$400(RelatorioContaReceberController x0) {
        return x0.cbbFormaPagamento;
    }

    static /* synthetic */ ContaReceberParcelaService access$500(RelatorioContaReceberController x0) {
        return x0.contaReceberParcelaService;
    }

    static /* synthetic */ void access$600(RelatorioContaReceberController x0, List x1) {
        x0.calculaTotal(x1);
    }

    static /* synthetic */ ConfiguracaoService access$700(RelatorioContaReceberController x0) {
        return x0.configuracaoService;
    }

    static /* synthetic */ BigDecimal access$800(RelatorioContaReceberController x0) {
        return x0.valor;
    }

    static /* synthetic */ BigDecimal access$900(RelatorioContaReceberController x0) {
        return x0.juros;
    }

    static /* synthetic */ BigDecimal access$1000(RelatorioContaReceberController x0) {
        return x0.desconto;
    }

    static /* synthetic */ BigDecimal access$1100(RelatorioContaReceberController x0) {
        return x0.total;
    }
}

