/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.financeiro.bean.MovimentoCaixaRecebimentoBean;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class RelatorioMovimentoCaixaExtratoController {
    public void geraRelatorio(MovimentoCaixa movimentoCaixa, List<MovimentoCaixaRecebimentoBean> recebimentos, Configuracao conf) throws MaximaException {
        try {
            if (recebimentos == null || recebimentos.isEmpty()) {
                recebimentos = new ArrayList<MovimentoCaixaRecebimentoBean>();
                MovimentoCaixaRecebimentoBean bean = new MovimentoCaixaRecebimentoBean();
                bean.setNome("-");
                bean.setValor(BigDecimal.ZERO);
                recebimentos.add(bean);
            }
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(true));
            params.put("DATA_ABERTURA", " " + movimentoCaixa.getDataAbertura().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")));
            if (movimentoCaixa.getDataFechamento() != null) {
                params.put("DATA_FECHAMENTO", " " + movimentoCaixa.getDataFechamento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")));
            }
            params.put("SALDO_ABERTURA", " R$ " + MaximaNumber.bigDecimalToString((BigDecimal)movimentoCaixa.getSaldoAbertura(), (int)2));
            params.put("VALOR_EM_CAIXA", " R$ " + MaximaNumber.bigDecimalToString((BigDecimal)movimentoCaixa.getValorEmCaixa(), (int)2));
            params.put("TOTAL_VENDIDO", " R$ " + MaximaNumber.bigDecimalToString((BigDecimal)movimentoCaixa.getTotalVendas(), (int)2));
            params.put("SUPRIMENTOS", " R$ " + MaximaNumber.bigDecimalToString((BigDecimal)movimentoCaixa.getSuprimento(), (int)2));
            params.put("SANGRIAS", " R$ " + MaximaNumber.bigDecimalToString((BigDecimal)movimentoCaixa.getSangria(), (int)2));
            params.put("PAGAMENTOS", " R$ " + MaximaNumber.bigDecimalToString((BigDecimal)movimentoCaixa.getPagamentos(), (int)2));
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(recebimentos);
            new PrintReport().showReport("/jasper/financeiro/movimentoCaixa/movimento-caixa-extrato.jasper", (JRDataSource)jrds, params);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(RelatorioMovimentoCaixaExtratoController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException(ex);
        }
    }
}

