/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.relatorio.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoSaida;
import br.com.maximasolutions.financeiro.relatorio.controller.RelatorioPagamentoController;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.financeiro.service.MovimentacaoSaidaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.geral.controller.FornecedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioPagamentoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private MovimentacaoSaidaService movimentacaoSaidaService;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private CentroCustoService centroCustoService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnFornecedorPesquisa;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfFornecedorPesquisa;
    @FXML
    private TextField tfFornecedorNome;
    @FXML
    private ComboBox<CentroCusto> cbbCentroCusto;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    private BigDecimal total;
    private BigDecimal valor;
    private BigDecimal juros;
    private BigDecimal desconto;
    private Fornecedor fornecedor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.fornecedor = null;
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        Stage progress = new MaximaDialogFX().progress(this.stageManager, "Gerando relat\u00f3rio.......");
        progress.show();
        this.exibeRelatorio(progress);
    }

    private void exibeRelatorio(Stage progress) {
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$exibeRelatorio$0(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {
            progress.close();
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel gerar lista para o relat\u00f3rio.");
        });
        service.start();
    }

    private void calculaTotal(List<MovimentacaoSaida> pagamentos) {
        this.valor = BigDecimal.ZERO;
        this.juros = BigDecimal.ZERO;
        this.desconto = BigDecimal.ZERO;
        this.total = BigDecimal.ZERO;
        pagamentos.stream().forEachOrdered(rec -> {
            this.valor = this.valor.add(rec.getValor());
            this.juros = this.juros.add(rec.getJuros());
            this.desconto = this.desconto.add(rec.getDesconto());
            this.total = this.total.add(rec.getTotal());
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnFornecedorPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.tfFornecedorPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaFornecedor();
            }
        });
        this.btnFornecedorPesquisa.setOnAction(event -> this.pesquisaFornecedorForm());
    }

    private void loadCombos() {
        this.cbbCentroCusto.setItems(FXCollections.observableList((List)this.centroCustoService.combo()));
        this.cbbFormaPagamento.setItems(FXCollections.observableList((List)FormaPagamentoUtils.listCombo()));
    }

    private void pesquisaFornecedor() {
        String fornecedorCodigo = this.tfFornecedorPesquisa.getText().trim();
        if (fornecedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long fornecedorCodigoNumero = Long.valueOf(fornecedorCodigo);
            Fornecedor fornecedorPesquisa = this.fornecedorService.getById(fornecedorCodigoNumero);
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
            } else {
                this.fornecedor = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de fornecedor n\u00e3o encontrado.");
                this.tfFornecedorPesquisa.requestFocus();
                this.tfFornecedorPesquisa.selectAll();
            }
            this.loadDadosFornecedor();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaFornecedorForm();
            return;
        }
    }

    private void pesquisaFornecedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorPesquisa.fxml", "Pesquisa de fornecedor");
            FornecedorPesquisaController controller = (FornecedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfFornecedorPesquisa.getText().trim());
            stage.showAndWait();
            Fornecedor fornecedorPesquisa = controller.getFornecedorSelecionado();
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'FornecedorPesquisa'");
        }
    }

    private void loadDadosFornecedor() {
        if (this.fornecedor != null) {
            this.tfFornecedorPesquisa.setText(this.fornecedor.getId().toString());
            this.tfFornecedorNome.setText(this.fornecedor.getNome().toUpperCase());
        } else {
            this.tfFornecedorNome.setText("");
            this.tfFornecedorPesquisa.setText("");
            this.tfFornecedorPesquisa.requestFocus();
        }
    }

    private /* synthetic */ void lambda$exibeRelatorio$0(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (!retorno.getSucesso().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ DatePicker access$000(RelatorioPagamentoController x0) {
        return x0.tfDataInicial;
    }

    static /* synthetic */ DatePicker access$100(RelatorioPagamentoController x0) {
        return x0.tfDataFinal;
    }

    static /* synthetic */ Fornecedor access$200(RelatorioPagamentoController x0) {
        return x0.fornecedor;
    }

    static /* synthetic */ ComboBox access$300(RelatorioPagamentoController x0) {
        return x0.cbbCentroCusto;
    }

    static /* synthetic */ ComboBox access$400(RelatorioPagamentoController x0) {
        return x0.cbbFormaPagamento;
    }

    static /* synthetic */ MovimentacaoSaidaService access$500(RelatorioPagamentoController x0) {
        return x0.movimentacaoSaidaService;
    }

    static /* synthetic */ void access$600(RelatorioPagamentoController x0, List x1) {
        x0.calculaTotal(x1);
    }

    static /* synthetic */ ConfiguracaoService access$700(RelatorioPagamentoController x0) {
        return x0.configuracaoService;
    }

    static /* synthetic */ BigDecimal access$800(RelatorioPagamentoController x0) {
        return x0.valor;
    }

    static /* synthetic */ BigDecimal access$900(RelatorioPagamentoController x0) {
        return x0.juros;
    }

    static /* synthetic */ BigDecimal access$1000(RelatorioPagamentoController x0) {
        return x0.desconto;
    }

    static /* synthetic */ BigDecimal access$1100(RelatorioPagamentoController x0) {
        return x0.total;
    }
}

