/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.relatorio.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixaSangria;
import br.com.maximasolutions.financeiro.relatorio.controller.RelatorioSangriaController;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.List;
import java.util.ResourceBundle;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioSangriaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfDescricao;
    private BigDecimal total;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        Stage progress = new MaximaDialogFX().progress(this.stageManager, "Gerando relat\u00f3rio.......");
        progress.show();
        this.exibeRelatorio(progress);
    }

    private void exibeRelatorio(Stage progress) {
        LocalDate inicio = (LocalDate)this.tfDataInicial.getValue();
        LocalDate fim = (LocalDate)this.tfDataFinal.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        LocalDateTime dataInicio = inicio.atTime(0, 0, 0, 0);
        LocalDateTime dataFim = fim.atTime(23, 59, 59, 59);
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$exibeRelatorio$0(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {
            progress.close();
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel gerar lista para o relat\u00f3rio.");
        });
        service.start();
    }

    private void calculaTotal(List<MovimentoCaixaSangria> sangrias) {
        this.total = BigDecimal.ZERO;
        sangrias.stream().forEachOrdered(rec -> {
            this.total = this.total.add(rec.getValor());
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
    }

    private /* synthetic */ void lambda$exibeRelatorio$0(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (!retorno.getSucesso().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ TextField access$000(RelatorioSangriaController x0) {
        return x0.tfDescricao;
    }

    static /* synthetic */ MovimentoCaixaService access$100(RelatorioSangriaController x0) {
        return x0.movimentoCaixaService;
    }

    static /* synthetic */ void access$200(RelatorioSangriaController x0, List x1) {
        x0.calculaTotal(x1);
    }

    static /* synthetic */ ConfiguracaoService access$300(RelatorioSangriaController x0) {
        return x0.configuracaoService;
    }

    static /* synthetic */ DatePicker access$400(RelatorioSangriaController x0) {
        return x0.tfDataInicial;
    }

    static /* synthetic */ DatePicker access$500(RelatorioSangriaController x0) {
        return x0.tfDataFinal;
    }

    static /* synthetic */ BigDecimal access$600(RelatorioSangriaController x0) {
        return x0.total;
    }
}

