/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.BoletoEmitido;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BoletoEmitidoRepository
extends JpaRepository<BoletoEmitido, Long> {
    @Query(value="SELECT o FROM BoletoEmitido o WHERE o.remessa = false ORDER BY o.id")
    public List<BoletoEmitido> remessa();

    @Query(value="SELECT o FROM BoletoEmitido o WHERE o.numeroDocumento like :numeroDocumento")
    public BoletoEmitido get(@Param(value="numeroDocumento") String var1);

    @Query(value="SELECT o FROM BoletoEmitido o WHERE (o.dataVencimento between :inicio and :fim) and o.cliente.nome like :filtro ORDER BY o.dataVencimento ASC")
    public List<BoletoEmitido> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT sum(o.valor) FROM BoletoEmitido o WHERE (o.dataVencimento between :inicio and :fim) and o.cliente.nome like :filtro")
    public BigDecimal total(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);
}

