/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.repository.ContaPagarParcelaRepositoryCustom;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class ContaPagarParcelaRepositoryCustomImpl
implements ContaPagarParcelaRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public List<ContaPagarParcela> relatorio(LocalDate inicio, LocalDate fim, Fornecedor fornecedor, CentroCusto centroCusto, FormaPagamento formaPagamento) {
        String hql = "SELECT o FROM ContaPagarParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento BETWEEN :dataInicial AND :dataFinal) ";
        if (fornecedor != null) {
            hql = hql + "AND (o.fornecedor.id = " + fornecedor.getId() + ") ";
        }
        if (centroCusto != null) {
            hql = hql + "AND (o.centroCusto.id = " + centroCusto.getId() + ") ";
        }
        if (formaPagamento != null) {
            hql = hql + "AND (o.formaPagamento = :formaPagamento) ";
        }
        Query query = this.entityManager.createQuery(hql + "ORDER BY o.dataVencimento ASC, o.fornecedor.nome ASC").setParameter("dataInicial", (Object)inicio).setParameter("dataFinal", (Object)fim);
        if (formaPagamento != null) {
            query.setParameter("formaPagamento", (Object)formaPagamento);
        }
        return query.getResultList();
    }
}

