/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepositoryCustom;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class ContaReceberParcelaRepositoryCustomImpl
implements ContaReceberParcelaRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public List<ContaReceberParcela> relatorio(LocalDate inicio, LocalDate fim, Long clienteId, Long centroCustoId, FormaPagamento formaPagamento) throws Exception {
        String hql = "SELECT o FROM ContaReceberParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento BETWEEN :dataInicial AND :dataFinal) ";
        if (clienteId != null) {
            hql = hql + "AND (o.cliente.id = " + clienteId + ") ";
        }
        if (centroCustoId != null) {
            hql = hql + "AND (o.centroCusto.id = " + centroCustoId + ") ";
        }
        if (formaPagamento != null) {
            hql = hql + "AND (o.formaPagamento = :formaPagamento) ";
        }
        Query query = this.entityManager.createQuery(hql + "ORDER BY o.dataVencimento ASC, o.cliente.nome ASC").setParameter("dataInicial", (Object)inicio).setParameter("dataFinal", (Object)fim);
        if (formaPagamento != null) {
            query.setParameter("formaPagamento", (Object)formaPagamento);
        }
        return query.getResultList();
    }
}

