/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.repository.MovimentacaoEntradaRepositoryCustom;
import br.com.maximasolutions.geral.modelo.Cliente;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class MovimentacaoEntradaRepositoryCustomImpl
implements MovimentacaoEntradaRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public List<MovimentacaoEntrada> relatorio(LocalDate inicio, LocalDate fim, Cliente cliente, CentroCusto centroCusto, FormaPagamento formaPagamento) {
        String hql = "SELECT o FROM MovimentacaoEntrada o WHERE o.estornada = false AND (o.dataMovimento BETWEEN :dataInicial AND :dataFinal) ";
        if (cliente != null) {
            hql = hql + "AND (o.cliente.id = " + cliente.getId() + ") ";
        }
        if (centroCusto != null) {
            hql = hql + "AND (o.contaReceberParcela.centroCusto.id = " + centroCusto.getId() + ") ";
        }
        if (formaPagamento != null) {
            hql = hql + "AND (o.formaPagamento = :formaPagamento) ";
        }
        Query query = this.entityManager.createQuery(hql + "ORDER BY o.dataMovimento DESC, o.cliente.nome ASC").setParameter("dataInicial", (Object)inicio).setParameter("dataFinal", (Object)fim);
        if (formaPagamento != null) {
            query.setParameter("formaPagamento", (Object)formaPagamento);
        }
        return query.getResultList();
    }
}

