/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.financeiro.modelo.BoletoEmitido;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.repository.BoletoEmitidoRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.service.BoletoEmitidoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class BoletoEmitidoServiceImpl
implements BoletoEmitidoService {
    @Autowired
    private BoletoEmitidoRepository boletoEmitidoRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;

    public List<BoletoEmitido> add(List<BoletoEmitido> boletos) {
        ArrayList<BoletoEmitido> retorno = new ArrayList<BoletoEmitido>();
        for (BoletoEmitido boleto : boletos) {
            ContaReceberParcela parcela = (ContaReceberParcela)this.contaReceberParcelaRepository.findById((Object)boleto.getContaReceberParcela().getId()).get();
            parcela.setBoleto(Boolean.valueOf(true));
            this.contaReceberParcelaRepository.save((Object)parcela);
            boleto = (BoletoEmitido)this.boletoEmitidoRepository.save((Object)boleto);
            retorno.add(boleto);
        }
        return retorno;
    }

    public void delete(List<BoletoEmitido> boletos) throws MaximaException {
        boletos.forEach(boleto -> {
            ContaReceberParcela parcela = (ContaReceberParcela)this.contaReceberParcelaRepository.findById((Object)boleto.getContaReceberParcela().getId()).get();
            parcela.setBoleto(Boolean.FALSE);
            this.contaReceberParcelaRepository.save((Object)parcela);
            this.boletoEmitidoRepository.deleteById((Object)boleto.getId());
        });
    }

    @Transactional(readOnly=true)
    public List<BoletoEmitido> remessa() {
        return this.boletoEmitidoRepository.remessa();
    }

    @Transactional(readOnly=true)
    public List<BoletoEmitido> lista(LocalDate inicio, LocalDate fim, String filtro) {
        return this.boletoEmitidoRepository.lista(inicio, fim, "%" + filtro + "%");
    }

    @Transactional(readOnly=true)
    public BigDecimal total(LocalDate inicio, LocalDate fim, String filtro) {
        BigDecimal total = this.boletoEmitidoRepository.total(inicio, fim, "%" + filtro + "%");
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }
}

